package cn.zhxu.data.test;

import cn.zhxu.data.DataConvertor;

import java.time.LocalDateTime;

/**
 * @author Troy.Zhou @ 2022/5/27
 * @since v
 */
public class YamlTests extends Tests {

    public YamlTests(DataConvertor convertor) {
        super(convertor);
    }

    @Override
    protected Object[] objectsToSerialize() {
        return new Object[] {
                new TimeObject(LocalDateTime.parse("2025-08-08T12:34"))
        };
    }

    @Override
    protected String[][] stringsToDeserialize() {
        return new String[][] {
                new String[] {
                        "---\n" +
                        "dateTime: \"2025-08-08 12:34\"\n" +
                        "date: \"2025-08-08\"\n" +
                        "time: \"12:34\"\n"
                }
        };
    }

    final String user1_0 = "---\n" +
            "id: 101001\n" +
            "name: \"Jack\"\n" +
            "school:\n" +
            "  id: 101\n" +
            "  name: \"清华\"\n" +
            "deleted: false";
    final String user2_0 = "---\n" +
            "id: 102002\n" +
            "name: \"Alice\"\n" +
            "school:\n" +
            "  id: 102\n" +
            "  name: \"北大\"\n" +
            "deleted: true";

    @Override
    String getStringForMapperValuesTest() {
        return "---\n" +
                "id: 1\n" +
                "age: 20\n";
    }

    @Override
    String getStringForArrayStreamTest() {
        return "---\n" +
                "- id\n" +
                "- age\n" +
                "- name\n";
    }

    @Override
    protected String user1Str() {
        return user1_0;
    }

    @Override
    protected boolean checkUser1Str(String serialize) {
        return user1_0.equals(serialize.trim());
    }

    @Override
    protected String user2Str() {
        return user2_0;
    }

    @Override
    protected boolean checkUser2Str(String serialize) {
        return user2_0.equals(serialize.trim());
    }

    @Override
    protected String userListStr() {
        return "---\n" +
                "- id: 101001\n" +
                "  name: \"Jack\"\n" +
                "  school:\n" +
                "    id: 101\n" +
                "    name: \"清华\"\n" +
                "  deleted: false\n" +
                "- id: 102002\n" +
                "  name: \"Alice\"\n" +
                "  school:\n" +
                "    id: 102\n" +
                "    name: \"北大\"\n" +
                "  deleted: true";
    }

    @Override
    protected boolean checkUserListStr(String serialize) {
        return userListStr().equals(serialize.trim());
    }

    @Override
    protected String objectListStr() {
        return "---\n" +
                "- id: 101001\n" +
                "  name: \"Jack\"\n" +
                "  school:\n" +
                "    id: 101\n" +
                "    name: \"清华\"\n" +
                "  deleted: false\n" +
                "- id: 102002\n" +
                "  name: \"Alice\"\n" +
                "  school:\n" +
                "    id: 102\n" +
                "    name: \"北大\"\n" +
                "  deleted: true\n" +
                "- \"Hello\"\n" +
                "- 100";
    }

    @Override
    protected boolean checkObjectListStr(String serialize) {
        return objectListStr().equals(serialize.trim());
    }

    @Override
    protected boolean checkObjectListStr(String serialize, boolean pretty) {
        return checkObjectListStr(serialize);
    }

    @Override
    protected boolean checkUserListStr(String serialize, boolean pretty) {
        return checkUserListStr(serialize);
    }

    @Override
    protected boolean checkUser2Str(String serialize, boolean pretty) {
        return checkUser2Str(serialize);
    }

    @Override
    protected boolean checkUser1Str(String serialize, boolean pretty) {
        return checkUser1Str(serialize);
    }

}
