package cn.zhxu.data.test;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;

public class TimeObject {

    private LocalDateTime dateTime;

    private LocalDate date;

    private LocalTime time;

    public TimeObject() {
    }

    public TimeObject(LocalDateTime dateTime) {
        this.dateTime = dateTime;
        this.date = dateTime.toLocalDate();
        this.time = dateTime.toLocalTime();
    }

    public LocalDate getDate() {
        return date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public LocalDateTime getDateTime() {
        return dateTime;
    }

    public void setDateTime(LocalDateTime dateTime) {
        this.dateTime = dateTime;
    }

    public LocalTime getTime() {
        return time;
    }

    public void setTime(LocalTime time) {
        this.time = time;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || getClass() != o.getClass()) return false;

        TimeObject that = (TimeObject) o;
        return Objects.equals(dateTime, that.dateTime) && Objects.equals(date, that.date) && Objects.equals(time, that.time);
    }

    @Override
    public int hashCode() {
        int result = Objects.hashCode(dateTime);
        result = 31 * result + Objects.hashCode(date);
        result = 31 * result + Objects.hashCode(time);
        return result;
    }

}
