/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.data.gson;

import cn.zhxu.data.Array;
import cn.zhxu.data.Mapper;
import cn.zhxu.data.TypeRef;
import cn.zhxu.data.gson.GsonArray;
import cn.zhxu.data.gson.GsonMap;
import com.google.gson.FormattingStyle;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.Strictness;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;

public class GsonMapper
implements Mapper {
    private final Gson gson;
    private final JsonObject json;

    public GsonMapper(Gson gson, JsonObject json) {
        this.gson = gson;
        this.json = json;
    }

    public int size() {
        return this.json.size();
    }

    public boolean isEmpty() {
        return this.json.size() == 0;
    }

    public Mapper getMapper(String key) {
        JsonElement subJson = this.json.get(key);
        if (subJson != null && subJson.isJsonObject()) {
            return new GsonMapper(this.gson, subJson.getAsJsonObject());
        }
        return null;
    }

    public Array getArray(String key) {
        JsonElement subJson = this.json.get(key);
        if (subJson != null && subJson.isJsonArray()) {
            return new GsonArray(this.gson, subJson.getAsJsonArray());
        }
        return null;
    }

    public boolean getBool(String key) {
        JsonElement val = this.json.get(key);
        if (val != null && val.isJsonPrimitive()) {
            return val.getAsBoolean();
        }
        return false;
    }

    public int getInt(String key) {
        JsonElement val = this.json.get(key);
        if (val != null && val.isJsonPrimitive()) {
            return val.getAsInt();
        }
        return 0;
    }

    public long getLong(String key) {
        JsonElement val = this.json.get(key);
        if (val != null && val.isJsonPrimitive()) {
            return val.getAsLong();
        }
        return 0L;
    }

    public float getFloat(String key) {
        JsonElement val = this.json.get(key);
        if (val != null && val.isJsonPrimitive()) {
            return val.getAsFloat();
        }
        return 0.0f;
    }

    public double getDouble(String key) {
        JsonElement val = this.json.get(key);
        if (val != null && val.isJsonPrimitive()) {
            return val.getAsDouble();
        }
        return 0.0;
    }

    public String getString(String key) {
        JsonElement val = this.json.get(key);
        if (val != null && val.isJsonPrimitive()) {
            return val.getAsString();
        }
        return null;
    }

    public <T> T toBean(Type type) {
        return (T)this.gson.fromJson((JsonElement)this.json, type);
    }

    public <T> T toBean(Class<T> type) {
        return (T)this.gson.fromJson((JsonElement)this.json, type);
    }

    public <T> T toBean(TypeRef<T> type) {
        return (T)this.gson.fromJson((JsonElement)this.json, type.getType());
    }

    public Map<String, Object> toMap() {
        return new GsonMap(this.json);
    }

    public boolean has(String key) {
        return this.json.has(key);
    }

    public Set<String> keySet() {
        return this.json.keySet();
    }

    public String toPretty() {
        try {
            StringWriter stringWriter = new StringWriter();
            JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
            jsonWriter.setStrictness(Strictness.LENIENT);
            jsonWriter.setFormattingStyle(FormattingStyle.PRETTY);
            Streams.write((JsonElement)this.json, (JsonWriter)jsonWriter);
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        return this.json.toString();
    }
}

