/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.data.gson;

import cn.zhxu.data.Array;
import cn.zhxu.data.Mapper;
import cn.zhxu.data.gson.GsonList;
import cn.zhxu.data.gson.GsonMapper;
import com.google.gson.FormattingStyle;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.Strictness;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;

public class GsonArray
implements Array {
    private final Gson gson;
    private final JsonArray json;

    public GsonArray(Gson gson, JsonArray json) {
        this.gson = gson;
        this.json = json;
    }

    public int size() {
        return this.json.size();
    }

    public boolean isEmpty() {
        return this.json.size() == 0;
    }

    public Mapper getMapper(int index) {
        JsonElement subJson = this.json.get(index);
        if (subJson != null && subJson.isJsonObject()) {
            return new GsonMapper(this.gson, subJson.getAsJsonObject());
        }
        return null;
    }

    public Array getArray(int index) {
        JsonElement subJson = this.json.get(index);
        if (subJson != null && subJson.isJsonArray()) {
            return new GsonArray(this.gson, subJson.getAsJsonArray());
        }
        return null;
    }

    public boolean getBool(int index) {
        JsonElement val = this.json.get(index);
        if (val != null && val.isJsonPrimitive()) {
            return val.getAsBoolean();
        }
        return false;
    }

    public int getInt(int index) {
        JsonElement val = this.json.get(index);
        if (val != null && val.isJsonPrimitive()) {
            return val.getAsInt();
        }
        return 0;
    }

    public long getLong(int index) {
        JsonElement val = this.json.get(index);
        if (val != null && val.isJsonPrimitive()) {
            return val.getAsLong();
        }
        return 0L;
    }

    public float getFloat(int index) {
        JsonElement val = this.json.get(index);
        if (val != null && val.isJsonPrimitive()) {
            return val.getAsFloat();
        }
        return 0.0f;
    }

    public double getDouble(int index) {
        JsonElement val = this.json.get(index);
        if (val != null && val.isJsonPrimitive()) {
            return val.getAsDouble();
        }
        return 0.0;
    }

    public String getString(int index) {
        JsonElement val = this.json.get(index);
        if (val != null && val.isJsonPrimitive()) {
            return val.getAsString();
        }
        return null;
    }

    public <T> List<T> toList(Class<T> type) {
        Object[] beans = (Object[])this.gson.fromJson((JsonElement)this.json, TypeToken.getArray(type).getType());
        return Arrays.asList(beans);
    }

    public List<Object> toList() {
        return new GsonList(this.json);
    }

    public String toPretty() {
        try {
            StringWriter stringWriter = new StringWriter();
            JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
            jsonWriter.setStrictness(Strictness.LENIENT);
            jsonWriter.setFormattingStyle(FormattingStyle.PRETTY);
            Streams.write((JsonElement)this.json, (JsonWriter)jsonWriter);
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        return this.json.toString();
    }
}

