/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.data.fastjson2;

import cn.zhxu.data.Array;
import cn.zhxu.data.Mapper;
import cn.zhxu.data.TypeRef;
import cn.zhxu.data.fastjson2.Fastjson2Array;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;

public class Fastjson2Mapper
implements Mapper {
    private final JSONObject json;

    public Fastjson2Mapper(JSONObject json) {
        this.json = json;
    }

    public int size() {
        return this.json.size();
    }

    public boolean isEmpty() {
        return this.json.isEmpty();
    }

    public Mapper getMapper(String key) {
        JSONObject subJson = this.json.getJSONObject(key);
        if (subJson != null) {
            return new Fastjson2Mapper(subJson);
        }
        return null;
    }

    public Array getArray(String key) {
        JSONArray subJson = this.json.getJSONArray(key);
        if (subJson != null) {
            return new Fastjson2Array(subJson);
        }
        return null;
    }

    public boolean getBool(String key) {
        return this.json.getBooleanValue(key);
    }

    public int getInt(String key) {
        return this.json.getIntValue(key);
    }

    public long getLong(String key) {
        return this.json.getLongValue(key);
    }

    public float getFloat(String key) {
        return this.json.getFloatValue(key);
    }

    public double getDouble(String key) {
        return this.json.getDoubleValue(key);
    }

    public String getString(String key) {
        return this.json.getString(key);
    }

    public boolean has(String key) {
        return this.json.containsKey(key);
    }

    public Set<String> keySet() {
        return this.json.keySet();
    }

    public String toString() {
        return this.json.toJSONString(new JSONWriter.Feature[0]);
    }

    public byte[] toJSONBBytes() {
        return this.json.toJSONBBytes(new JSONWriter.Feature[0]);
    }

    public <T> T toBean(Type type) {
        return (T)this.json.to(type, new JSONReader.Feature[0]);
    }

    public <T> T toBean(Class<T> type) {
        return (T)this.json.to(type, new JSONReader.Feature[0]);
    }

    public <T> T toBean(TypeRef<T> type) {
        return (T)this.json.to(type.getType(), new JSONReader.Feature[0]);
    }

    public Map<String, Object> toMap() {
        return this.json;
    }
}

