/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.crud.service;

import cn.zhxu.crud.Copyer;
import cn.zhxu.crud.Identifier;
import cn.zhxu.crud.entity.Del;
import cn.zhxu.crud.service.KeyExistsException;
import cn.zhxu.crud.service.NotExistsException;
import cn.zhxu.crud.service.Saved;
import cn.zhxu.crud.service.ServiceHook;
import cn.zhxu.crud.service.ServiceHooks;
import jakarta.transaction.Transactional;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.CrudRepository;

public class BaseService<Rep extends CrudRepository<T, ID>, T extends Copyer<T>, ID, Input> {
    private static ServiceHook hook = null;
    private Rep repository;
    private final Class<T> domainClass;

    public static void registerHook(ServiceHook hook) {
        ServiceHook h = BaseService.hook;
        BaseService.hook = h != null ? new ServiceHooks(h, Objects.requireNonNull(hook)) : Objects.requireNonNull(hook);
    }

    public BaseService() {
        Type[] types = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments();
        this.domainClass = (Class)types[1];
    }

    @Autowired
    public void setRepository(Rep repository) {
        this.repository = repository;
    }

    public Rep repository() {
        return this.repository;
    }

    public Optional<T> optional(ID id) {
        return this.repository.findById(id).filter(d -> {
            Del del;
            if (hook != null && !hook.onFindById(d)) {
                return false;
            }
            return !(d instanceof Del) || !(del = (Del)((Object)d)).isDeleted();
        });
    }

    public T nullable(ID id) {
        return (T)((Copyer)this.optional(id).orElse(null));
    }

    public T require(ID id) {
        return (T)((Copyer)this.optional(id).orElseThrow(() -> new NotExistsException("No " + this.domainClass.getSimpleName() + ": " + id)));
    }

    protected T forSaveByKeyValue(Input input) {
        return null;
    }

    protected String keyValueExistsTip(Input input) {
        return "\u952e\u503c\u5df2\u5b58\u5728";
    }

    protected T newInstance() {
        try {
            return (T)((Copyer)this.domainClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    @Transactional
    public Saved<T> save(Input input) {
        Object old = null;
        Object entity = this.forSaveByKeyValue(input);
        if (entity == null) {
            Identifier identifier;
            if (input instanceof Identifier && (identifier = (Identifier)input).getId() != null) {
                entity = this.require(identifier.getId());
                old = entity.copy();
            } else {
                entity = this.newInstance();
            }
        } else {
            if (input instanceof Identifier) {
                Identifier iid = (Identifier)input;
                if (entity instanceof Identifier) {
                    Identifier did = (Identifier)entity;
                    if (!Objects.equals(iid.getId(), did.getId())) {
                        throw new KeyExistsException(this.keyValueExistsTip(input));
                    }
                }
            }
            old = entity.copy();
        }
        if (old != null) {
            if (hook != null) {
                hook.onUpdating(entity, input);
            }
            this.onUpdating(entity, input);
        } else {
            if (hook != null) {
                hook.onCreating(input);
            }
            this.onCreating(input);
        }
        BeanUtils.copyProperties(input, entity);
        if (hook != null) {
            hook.onSaving(entity, input);
        }
        this.onSaving(entity, input);
        entity = (Copyer)this.repository.save(entity);
        if (hook != null) {
            hook.onSaved(entity, input);
        }
        this.onSaved(entity, input);
        return new Saved<Object>(old, entity);
    }

    protected void onCreating(Input input) {
    }

    protected void onUpdating(T entity, Input input) {
    }

    protected void onSaving(T entity, Input input) {
    }

    protected void onSaved(T entity, Input input) {
    }

    @Transactional
    public T delete(ID id) {
        Optional opt = this.repository.findById(id);
        if (opt.isEmpty()) {
            return null;
        }
        Copyer entity = (Copyer)opt.get();
        if (hook != null) {
            hook.onDeleting(entity);
        }
        this.onDeleting(entity);
        if (entity instanceof Del) {
            Del del = (Del)((Object)entity);
            del.setDeleted(true);
            this.repository.save((Object)entity);
        } else {
            this.repository.delete((Object)entity);
        }
        if (hook != null) {
            hook.onDeleted(entity);
        }
        this.onDeleted(entity);
        return (T)entity;
    }

    protected void onDeleting(T entity) {
    }

    protected void onDeleted(T entity) {
    }
}

