package cn.zhxu.crud.model;

import cn.zhxu.bs.bean.DbField;
import cn.zhxu.bs.operator.Between;
import cn.zhxu.bs.operator.StartWith;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;

@Getter
@Setter
public class BaseVO {

    @DbField(onlyOn = StartWith.class)
    private String updateBy;

    @DbField(onlyOn = Between.class)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date dateCreated;

    @DbField(onlyOn = StartWith.class)
    private String createBy;

    @DbField(onlyOn = Between.class)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date lastUpdated;

}
