package cn.zhxu.crud.service;

import java.util.Objects;

public class ServiceHooks implements ServiceHook {

    private final ServiceHook hook1;
    private final ServiceHook hook2;

    public ServiceHooks(ServiceHook hook1, ServiceHook hook2) {
        this.hook1 = Objects.requireNonNull(hook1);
        this.hook2 = Objects.requireNonNull(hook2);
    }

    @Override
    public boolean onFindById(Object entity) {
        return hook1.onFindById(entity) && hook2.onFindById(entity);
    }

    @Override
    public void onCreating(Object input) {
        hook1.onCreating(input);
        hook2.onCreating(input);
    }

    @Override
    public void onUpdating(Object entity, Object input) {
        hook1.onUpdating(entity, input);
        hook2.onUpdating(entity, input);
    }

    @Override
    public void onSaving(Object entity, Object input) {
        hook1.onSaving(entity, input);
        hook2.onSaving(entity, input);
    }

    @Override
    public void onSaved(Object entity, Object input) {
        hook1.onSaved(entity, input);
        hook2.onSaved(entity, input);
    }

    @Override
    public void onDeleting(Object entity) {
        hook1.onDeleting(entity);
        hook2.onDeleting(entity);
    }

    @Override
    public void onDeleted(Object entity) {
        hook1.onDeleted(entity);
        hook2.onDeleted(entity);
    }

}
