package cn.zhxu.crud;

import cn.zhxu.bs.util.MapUtils;
import cn.zhxu.crud.model.IdName;

import java.util.Map;

public interface INGetter {

    Integer getId();

    String getName();

    default IdName<Integer> idName() {
        return new IdName<>(getId(), getName());
    }

    static Map<String, Object> onlySelect() {
        return MapUtils.builder()
                .onlySelect(INGetter::getId, INGetter::getName)
                .build();
    }

    static Map<String, Object> onlySelect(boolean condition) {
        return condition ? onlySelect() : null;
    }

}
