/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.util;

public class StringUtils {
    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        if (len == 0) {
            return true;
        }
        block3: for (int i = 0; i < len; ++i) {
            switch (str.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static String firstCharToLoweCase(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        char first = str.charAt(0);
        if (first >= 'A' && first <= 'Z') {
            first = (char)(first + 32);
            if (str.length() == 1) {
                return String.valueOf(first);
            }
            return first + str.substring(1);
        }
        return str;
    }

    public static int containCount(String src, int from, int to, char[] targets) {
        int count = 0;
        if (src != null) {
            from = Math.max(from, 0);
            to = Math.min(to, src.length());
            for (int i = from; i < to; ++i) {
                char c = src.charAt(i);
                boolean contained = false;
                for (char target : targets) {
                    if (c != target) continue;
                    contained = true;
                    break;
                }
                if (!contained) continue;
                ++count;
            }
        }
        return count;
    }

    public static String toHyphenation(String src, String hyphenation) {
        StringBuilder sb = new StringBuilder(src);
        int cnt = 0;
        for (int i = 1; i < src.length(); ++i) {
            if (!Character.isUpperCase(src.charAt(i))) continue;
            sb.insert(i + cnt, hyphenation);
            cnt += hyphenation.length();
        }
        return sb.toString().toLowerCase();
    }

    public static String toUnderline(String src) {
        return StringUtils.toHyphenation(src, "_");
    }

    public static boolean sqlContains(String sql, String column) {
        int cLen = column.length();
        int idx = sql.indexOf(column);
        while (idx >= 0) {
            if (idx > 0 && StringUtils.isSqlColumnChar(sql.charAt(idx - 1))) {
                idx = sql.indexOf(column, idx + cLen);
                continue;
            }
            int endIdx = idx + cLen;
            if (endIdx < sql.length() && StringUtils.isSqlColumnChar(sql.charAt(endIdx))) {
                idx = sql.indexOf(column, idx + cLen);
                continue;
            }
            return true;
        }
        return false;
    }

    public static boolean isSqlColumnChar(char c) {
        return 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '_';
    }

    public static int countOf(String str, char target) {
        if (str == null) {
            return 0;
        }
        int count = 0;
        int index = str.indexOf(target);
        while (index >= 0 && index < str.length()) {
            index = str.indexOf(target, index + 1);
            ++count;
        }
        return count;
    }
}

