/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.implement;

import cn.zhxu.bs.BeanMeta;
import cn.zhxu.bs.BeanReflector;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldMeta;
import cn.zhxu.bs.ResultFilter;
import cn.zhxu.bs.SearchException;
import cn.zhxu.bs.SearchResult;
import cn.zhxu.bs.SearchSql;
import cn.zhxu.bs.SqlExecutor;
import cn.zhxu.bs.SqlResult;
import cn.zhxu.bs.bean.BeanAware;
import cn.zhxu.bs.bean.ParamAware;
import cn.zhxu.bs.implement.BaseSearcher;
import cn.zhxu.bs.implement.DefaultBeanReflector;
import cn.zhxu.bs.param.FetchType;
import cn.zhxu.bs.util.FieldFns;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DefaultBeanSearcher
extends BaseSearcher
implements BeanSearcher {
    private BeanReflector beanReflector = new DefaultBeanReflector();

    public DefaultBeanSearcher() {
    }

    public DefaultBeanSearcher(SqlExecutor sqlExecutor) {
        super(sqlExecutor);
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass) {
        return this.search(beanClass, null, new FetchType(0));
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, Map<String, Object> paraMap) {
        return this.search(beanClass, paraMap, new FetchType(0));
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, String summaryField) {
        return this.search(beanClass, null, summaryField);
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, Map<String, Object> paraMap, String summaryField) {
        if (summaryField != null) {
            return this.search(beanClass, paraMap, new String[]{summaryField});
        }
        return this.search(beanClass, paraMap);
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, FieldFns.FieldFn<T, ?> summaryField) {
        return this.search(beanClass, null, summaryField);
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, Map<String, Object> paraMap, FieldFns.FieldFn<T, ?> summaryField) {
        if (summaryField != null) {
            return this.search(beanClass, paraMap, FieldFns.name(summaryField));
        }
        return this.search(beanClass, paraMap);
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, String[] summaryFields) {
        return this.search(beanClass, null, summaryFields);
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, Map<String, Object> paraMap, String[] summaryFields) {
        if (summaryFields != null) {
            return this.search(beanClass, paraMap, new FetchType(0, summaryFields));
        }
        return this.search(beanClass, paraMap);
    }

    @Override
    public <T> T searchFirst(Class<T> beanClass) {
        return this.searchFirst(beanClass, null);
    }

    @Override
    public <T> T searchFirst(Class<T> beanClass, Map<String, Object> paraMap) {
        FetchType fetchType = new FetchType(1);
        List<T> list = this.search(beanClass, paraMap, fetchType).getDataList();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public <T> List<T> searchList(Class<T> beanClass) {
        return this.searchList(beanClass, null);
    }

    @Override
    public <T> List<T> searchList(Class<T> beanClass, Map<String, Object> paraMap) {
        return this.search(beanClass, paraMap, new FetchType(2)).getDataList();
    }

    @Override
    public <T> List<T> searchAll(Class<T> beanClass) {
        return this.searchAll(beanClass, null);
    }

    @Override
    public <T> List<T> searchAll(Class<T> beanClass, Map<String, Object> paraMap) {
        return this.search(beanClass, paraMap, new FetchType(3)).getDataList();
    }

    protected <T> SearchResult<T> search(Class<T> beanClass, Map<String, Object> paraMap, FetchType fetchType) {
        SqlResult<T> sqlResult = this.doSearch(beanClass, paraMap, fetchType);
        try {
            SearchSql<T> searchSql = sqlResult.getSearchSql();
            Number totalCount = 0L;
            Number[] summaries = SearchResult.EMPTY_SUMMARIES;
            if (searchSql.isShouldQueryCluster()) {
                totalCount = this.getCountFromSqlResult(sqlResult);
                summaries = this.getSummaryFromSqlResult(sqlResult);
            }
            SearchResult result = new SearchResult(totalCount, sqlResult.getPageSize(), summaries);
            BeanMeta<T> beanMeta = searchSql.getBeanMeta();
            SqlResult.ResultSet listResult = sqlResult.getListResult();
            if (listResult != null) {
                List<FieldMeta> fieldMetas = searchSql.getFetchFields().stream().map(beanMeta::requireFieldMeta).collect(Collectors.toList());
                this.collectList(result.getDataList(), listResult, beanMeta, fieldMetas, paraMap);
            }
            SearchResult searchResult = this.doFilter(result, beanMeta, paraMap, fetchType);
            if (sqlResult != null) {
                sqlResult.close();
            }
            return searchResult;
        }
        catch (Throwable throwable) {
            try {
                if (sqlResult != null) {
                    try {
                        sqlResult.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw new SearchException("A exception occurred when collecting sql result!", e);
            }
        }
    }

    protected <T> void collectList(List<T> dataList, SqlResult.ResultSet listResult, BeanMeta<T> beanMeta, List<FieldMeta> fieldMetas, Map<String, Object> paraMap) throws SQLException {
        while (listResult.next()) {
            T bean = this.beanReflector.reflect(beanMeta, fieldMetas, dbAlias -> {
                try {
                    return listResult.get((String)dbAlias);
                }
                catch (SQLException e) {
                    throw new SearchException("A exception occurred when collecting sql result!", e);
                }
            });
            if (bean instanceof BeanAware) {
                ((BeanAware)bean).afterAssembly();
            }
            if (bean instanceof ParamAware) {
                ((ParamAware)bean).afterAssembly(paraMap);
            }
            dataList.add(bean);
        }
    }

    protected <T> SearchResult<T> doFilter(SearchResult<T> result, BeanMeta<T> beanMeta, Map<String, Object> paraMap, FetchType fetchType) {
        for (ResultFilter filter : this.getResultFilters()) {
            result = filter.doBeanFilter(result, beanMeta, paraMap, fetchType);
        }
        return result;
    }

    public BeanReflector getBeanReflector() {
        return this.beanReflector;
    }

    public void setBeanReflector(BeanReflector beanReflector) {
        this.beanReflector = Objects.requireNonNull(beanReflector);
    }
}

