/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs;

import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.dialect.Dialect;
import cn.zhxu.bs.dialect.DialectSensor;
import cn.zhxu.bs.dialect.DialectWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class FieldOpPool
extends DialectWrapper {
    private List<FieldOp> fieldOps;
    private final Map<Object, FieldOp> cache = new ConcurrentHashMap<Object, FieldOp>();

    public FieldOpPool(List<FieldOp> fieldOps) {
        this.fieldOps = this.checkFieldOps(fieldOps);
    }

    public FieldOpPool() {
        this.fieldOps = new ArrayList<FieldOp>();
        this.checkAdd(FieldOps.Equal);
        this.checkAdd(FieldOps.NotEqual);
        this.checkAdd(FieldOps.GreaterThan);
        this.checkAdd(FieldOps.GreaterEqual);
        this.checkAdd(FieldOps.LessThan);
        this.checkAdd(FieldOps.LessEqual);
        this.checkAdd(FieldOps.Between);
        this.checkAdd(FieldOps.NotBetween);
        this.checkAdd(FieldOps.Contain);
        this.checkAdd(FieldOps.StartWith);
        this.checkAdd(FieldOps.EndWith);
        this.checkAdd(FieldOps.OrLike);
        this.checkAdd(FieldOps.NotLike);
        this.checkAdd(FieldOps.InList);
        this.checkAdd(FieldOps.NotIn);
        this.checkAdd(FieldOps.IsNull);
        this.checkAdd(FieldOps.NotNull);
        this.checkAdd(FieldOps.Empty);
        this.checkAdd(FieldOps.NotEmpty);
    }

    public FieldOp getFieldOp(Object key) {
        if (key == null) {
            return null;
        }
        FieldOp fOp = this.cache.get(key);
        if (fOp == null && key instanceof FieldOp) {
            fOp = this.cache.get(((FieldOp)key).name());
        }
        if (fOp != null) {
            return fOp;
        }
        for (FieldOp op : this.fieldOps) {
            if (!this.isMatch(op, key)) continue;
            if (key instanceof FieldOp) {
                this.cache.put(((FieldOp)key).name(), op);
            } else {
                this.cache.put(key, op);
            }
            return op;
        }
        return null;
    }

    private boolean isMatch(FieldOp op, Object key) {
        if (key instanceof FieldOp) {
            return op.sameTo((FieldOp)key);
        }
        if (key instanceof String) {
            return op.isNamed((String)key);
        }
        if (key instanceof Class) {
            return op.getClass() == key;
        }
        return false;
    }

    public List<FieldOp> getFieldOps() {
        return this.fieldOps;
    }

    public synchronized void setFieldOps(List<FieldOp> fieldOps) {
        this.fieldOps = this.checkFieldOps(fieldOps);
        this.updateAllOpDialect();
    }

    public synchronized void addFieldOp(FieldOp fieldOp) {
        if (fieldOp != null) {
            this.checkAdd(fieldOp);
            this.updateOpDialect(fieldOp);
        }
    }

    private List<FieldOp> checkFieldOps(List<FieldOp> fieldOps) {
        List<FieldOp> ops = Objects.requireNonNull(fieldOps);
        ops.forEach(this::checkFieldOp);
        return ops;
    }

    private void checkAdd(FieldOp fieldOp) {
        this.checkFieldOp(fieldOp);
        this.fieldOps.add(fieldOp);
    }

    private void checkFieldOp(FieldOp fieldOp) {
        if (fieldOp.isNonPublic()) {
            throw new IllegalStateException("Only public FieldOp can add into FieldOpPool, and " + fieldOp + " is non public.");
        }
    }

    @Override
    public synchronized void setDialect(Dialect dialect) {
        if (dialect != null) {
            super.setDialect(dialect);
            this.updateAllOpDialect();
        }
    }

    private void updateAllOpDialect() {
        for (FieldOp op : this.fieldOps) {
            this.updateOpDialect(op);
        }
    }

    private void updateOpDialect(FieldOp op) {
        Dialect dialect;
        if (op instanceof DialectSensor && (dialect = this.getDialect()) != null) {
            ((DialectSensor)((Object)op)).setDialect(dialect);
        }
    }
}

