/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.implement;

import cn.zhxu.bs.DbMapping;
import cn.zhxu.bs.bean.DbType;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;

public class DefaultDbTypeMapper
implements DbMapping.DbTypeMapper {
    private DbType enumAutoMapTo = DbType.INT;

    public DefaultDbTypeMapper() {
    }

    public DefaultDbTypeMapper(DbType enumAutoMapTo) {
        this.enumAutoMapTo = enumAutoMapTo;
    }

    @Override
    public DbType map(Class<?> fieldType) {
        if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
            return DbType.BOOL;
        }
        if (fieldType == Byte.TYPE || fieldType == Byte.class) {
            return DbType.BYTE;
        }
        if (fieldType == Short.TYPE || fieldType == Short.class) {
            return DbType.SHORT;
        }
        if (fieldType == Integer.TYPE || fieldType == Integer.class) {
            return DbType.INT;
        }
        if (fieldType == Long.TYPE || fieldType == Long.class) {
            return DbType.LONG;
        }
        if (fieldType == Float.TYPE || fieldType == Float.class) {
            return DbType.FLOAT;
        }
        if (fieldType == Double.TYPE || fieldType == Double.class) {
            return DbType.DOUBLE;
        }
        if (fieldType == BigDecimal.class) {
            return DbType.DECIMAL;
        }
        if (fieldType == String.class) {
            return DbType.STRING;
        }
        if (fieldType == java.sql.Date.class || fieldType == LocalDate.class) {
            return DbType.DATE;
        }
        if (fieldType == Time.class || fieldType == LocalTime.class) {
            return DbType.TIME;
        }
        if (fieldType == Date.class || fieldType == Timestamp.class || fieldType == LocalDateTime.class) {
            return DbType.DATETIME;
        }
        if (this.enumAutoMapTo != null && Enum.class.isAssignableFrom(fieldType)) {
            return this.enumAutoMapTo;
        }
        return DbType.UNKNOWN;
    }

    public DbType getEnumAutoMapTo() {
        return this.enumAutoMapTo;
    }

    public void setEnumAutoMapTo(DbType enumAutoMapTo) {
        this.enumAutoMapTo = enumAutoMapTo;
    }
}

