/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.convertor;

import cn.zhxu.bs.FieldConvertor;
import cn.zhxu.bs.FieldMeta;
import cn.zhxu.bs.bean.DbType;
import cn.zhxu.bs.util.StringUtils;
import cn.zhxu.xjson.JsonKit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFieldConvertor
implements FieldConvertor.BFieldConvertor {
    static final Logger log = LoggerFactory.getLogger(JsonFieldConvertor.class);
    private boolean failOnError = true;

    public JsonFieldConvertor() {
    }

    public JsonFieldConvertor(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @Override
    public boolean supports(FieldMeta meta, Class<?> valueType) {
        return meta.getType() != String.class && meta.getDbType() == DbType.JSON;
    }

    @Override
    public Object convert(FieldMeta meta, Object value) {
        String json = value.toString();
        if (StringUtils.isBlank(json)) {
            return null;
        }
        Class<?> type = meta.getType();
        if (this.failOnError) {
            return JsonKit.toBean(type, (String)json);
        }
        try {
            return JsonKit.toBean(type, (String)json);
        }
        catch (Exception e) {
            log.warn("Json parse error [{}] for {}, the value is: {}", new Object[]{e.getClass().getName(), type, json});
            return null;
        }
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }
}

