/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.convertor;

import cn.zhxu.bs.FieldConvertor;
import cn.zhxu.bs.FieldMeta;
import cn.zhxu.bs.util.ObjKey2;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class B2MFieldConvertor
implements FieldConvertor.MFieldConvertor {
    private final List<FieldConvertor.BFieldConvertor> convertors;
    private final Map<ObjKey2, FieldConvertor.BFieldConvertor> cache = new ConcurrentHashMap<ObjKey2, FieldConvertor.BFieldConvertor>();
    static final FieldConvertor.BFieldConvertor NULL_CONVERTOR = (meta, valueType) -> false;

    public B2MFieldConvertor(List<FieldConvertor.BFieldConvertor> convertors) {
        this.convertors = convertors;
    }

    @Override
    public boolean supports(FieldMeta meta, Class<?> valueType) {
        ObjKey2 key = new ObjKey2(meta, valueType);
        FieldConvertor.BFieldConvertor convertor = this.cache.get(key);
        if (convertor == NULL_CONVERTOR) {
            return false;
        }
        if (convertor != null) {
            return true;
        }
        for (FieldConvertor.BFieldConvertor c : this.convertors) {
            if (!c.supports(meta, valueType)) continue;
            this.cache.put(key, c);
            return true;
        }
        this.cache.put(key, NULL_CONVERTOR);
        return false;
    }

    @Override
    public Object convert(FieldMeta meta, Object value) {
        ObjKey2 key = new ObjKey2(meta, value.getClass());
        FieldConvertor.BFieldConvertor convertor = this.cache.get(key);
        if (convertor != null) {
            return convertor.convert(meta, value);
        }
        throw new IllegalStateException("The supports(FieldMeta, Class<?>) method must be called first and return true before invoking convert(FieldMeta, Object) method.");
    }
}

