/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.solon;

import cn.zhxu.bs.FieldConvertor;
import cn.zhxu.bs.convertor.B2MFieldConvertor;
import cn.zhxu.bs.convertor.BoolFieldConvertor;
import cn.zhxu.bs.convertor.BoolNumFieldConvertor;
import cn.zhxu.bs.convertor.BoolParamConvertor;
import cn.zhxu.bs.convertor.DateFieldConvertor;
import cn.zhxu.bs.convertor.DateFormatFieldConvertor;
import cn.zhxu.bs.convertor.DateParamConvertor;
import cn.zhxu.bs.convertor.DateTimeParamConvertor;
import cn.zhxu.bs.convertor.EnumFieldConvertor;
import cn.zhxu.bs.convertor.EnumParamConvertor;
import cn.zhxu.bs.convertor.JsonFieldConvertor;
import cn.zhxu.bs.convertor.ListFieldConvertor;
import cn.zhxu.bs.convertor.NumberFieldConvertor;
import cn.zhxu.bs.convertor.NumberParamConvertor;
import cn.zhxu.bs.convertor.OracleTimestampFieldConvertor;
import cn.zhxu.bs.convertor.StrNumFieldConvertor;
import cn.zhxu.bs.convertor.StringFieldConvertor;
import cn.zhxu.bs.convertor.TimeFieldConvertor;
import cn.zhxu.bs.convertor.TimeParamConvertor;
import cn.zhxu.bs.solon.prop.BeanSearcherFieldConvertor;
import cn.zhxu.bs.solon.prop.BeanSearcherParams;
import cn.zhxu.bs.solon.prop.BeanSearcherProperties;
import cn.zhxu.xjson.JsonKit;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.sql.TIMESTAMP;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Inject;

@Configuration
public class BeanSearcherConvertors {
    @Inject
    BeanSearcherProperties config;

    @Bean
    @Condition(onMissingBean=BoolParamConvertor.class)
    public BoolParamConvertor boolParamConvertor() {
        return new BoolParamConvertor();
    }

    @Bean
    @Condition(onMissingBean=NumberParamConvertor.class)
    public NumberParamConvertor numberParamConvertor() {
        return new NumberParamConvertor();
    }

    @Bean
    @Condition(onMissingBean=DateParamConvertor.class)
    public DateParamConvertor dateParamConvertor() {
        return new DateParamConvertor(this.config.getParams().getConvertor().getDateTarget());
    }

    @Bean
    @Condition(onMissingBean=TimeParamConvertor.class)
    public TimeParamConvertor timeParamConvertor() {
        return new TimeParamConvertor(this.config.getParams().getConvertor().getTimeTarget());
    }

    @Bean
    @Condition(onMissingBean=DateTimeParamConvertor.class)
    public DateTimeParamConvertor dateTimeParamConvertor() {
        BeanSearcherParams.Convertor conf = this.config.getParams().getConvertor();
        DateTimeParamConvertor convertor = new DateTimeParamConvertor(conf.getDateTimeTarget());
        convertor.setZoneId(conf.getZoneId());
        return convertor;
    }

    @Bean
    @Condition(onMissingBean=EnumParamConvertor.class)
    public EnumParamConvertor enumParamConvertor() {
        return new EnumParamConvertor();
    }

    @Bean
    @Condition(onMissingBean=NumberFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-number:true}=true")
    public NumberFieldConvertor numberFieldConvertor() {
        return new NumberFieldConvertor();
    }

    @Bean
    @Condition(onMissingBean=StrNumFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-str-num:true}=true")
    public StrNumFieldConvertor strNumFieldConvertor() {
        return new StrNumFieldConvertor();
    }

    @Bean
    @Condition(onMissingBean=BoolNumFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-bool-num:true}=true")
    public BoolNumFieldConvertor boolNumFieldConvertor() {
        return new BoolNumFieldConvertor();
    }

    @Bean
    @Condition(onMissingBean=BoolFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-bool:true}=true")
    public BoolFieldConvertor boolFieldConvertor() {
        String[] falseValues = this.config.getFieldConvertor().getBoolFalseValues();
        BoolFieldConvertor convertor = new BoolFieldConvertor();
        if (falseValues != null) {
            convertor.addFalseValues(falseValues);
        }
        return convertor;
    }

    @Bean
    @Condition(onMissingBean=DateFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-date:true}=true")
    public DateFieldConvertor dateFieldConvertor() {
        DateFieldConvertor convertor = new DateFieldConvertor();
        ZoneId zoneId = this.config.getFieldConvertor().getZoneId();
        if (zoneId != null) {
            convertor.setZoneId(zoneId);
        }
        return convertor;
    }

    @Bean
    @Condition(onMissingBean=TimeFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-time:true}=true")
    public TimeFieldConvertor timeFieldConvertor() {
        return new TimeFieldConvertor();
    }

    @Bean
    @Condition(onMissingBean=EnumFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-enum:true}=true")
    public EnumFieldConvertor enumFieldConvertor() {
        BeanSearcherFieldConvertor conf = this.config.getFieldConvertor();
        EnumFieldConvertor convertor = new EnumFieldConvertor();
        convertor.setFailOnError(conf.isEnumFailOnError());
        convertor.setIgnoreCase(conf.isEnumIgnoreCase());
        return convertor;
    }

    @Bean
    @Condition(onMissingBean=JsonFieldConvertor.class, onClass=JsonKit.class, onProperty="${bean-searcher.field-convertor.use-json:true}=true")
    public JsonFieldConvertor jsonFieldConvertor() {
        BeanSearcherFieldConvertor conf = this.config.getFieldConvertor();
        return new JsonFieldConvertor(conf.isJsonFailOnError());
    }

    @Bean
    @Condition(onMissingBean=OracleTimestampFieldConvertor.class, onClass=TIMESTAMP.class, onProperty="${bean-searcher.field-convertor.use-oracle-timestamp:true}=true")
    public OracleTimestampFieldConvertor oracleTimestampFieldConvertor() {
        return new OracleTimestampFieldConvertor();
    }

    @Bean
    @Condition(onMissingBean=ListFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-list:true}=true")
    public ListFieldConvertor listFieldConvertor(List<ListFieldConvertor.Convertor> convertors0) {
        ArrayList convertors = new ArrayList();
        convertors0.forEach(convertors::add);
        BeanSearcherFieldConvertor conf = this.config.getFieldConvertor();
        ListFieldConvertor convertor = new ListFieldConvertor(conf.getListItemSeparator());
        if (convertors != null) {
            convertor.setConvertors(convertors);
        }
        return convertor;
    }

    @Bean
    @Condition(onMissingBean=DateFormatFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-date-format:true}=true")
    public DateFormatFieldConvertor dateFormatFieldConvertor() {
        BeanSearcherFieldConvertor conf = this.config.getFieldConvertor();
        Map<String, String> dateFormats = conf.getDateFormats();
        ZoneId zoneId = conf.getZoneId();
        DateFormatFieldConvertor convertor = new DateFormatFieldConvertor();
        if (dateFormats != null) {
            dateFormats.forEach((key, value) -> {
                String scope = key.replace('-', ':');
                convertor.setFormat(scope, value);
            });
        }
        if (zoneId != null) {
            convertor.setZoneId(zoneId);
        }
        return convertor;
    }

    @Bean
    @Condition(onMissingBean=StringFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-string}=true")
    public StringFieldConvertor stringFieldConvertor() {
        return new StringFieldConvertor();
    }

    @Bean
    @Condition(onMissingBean=B2MFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-b2-m}=true")
    public B2MFieldConvertor b2mFieldConvertor(List<FieldConvertor.BFieldConvertor> convertors) {
        if (convertors != null) {
            return new B2MFieldConvertor(convertors);
        }
        return new B2MFieldConvertor(Collections.emptyList());
    }
}

