/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.solon;

import cn.zhxu.bs.BeanReflector;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldConvertor;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOpPool;
import cn.zhxu.bs.MapSearcher;
import cn.zhxu.bs.MetaResolver;
import cn.zhxu.bs.PageExtractor;
import cn.zhxu.bs.ParamFilter;
import cn.zhxu.bs.ParamResolver;
import cn.zhxu.bs.ResultFilter;
import cn.zhxu.bs.SqlExecutor;
import cn.zhxu.bs.SqlInterceptor;
import cn.zhxu.bs.SqlResolver;
import cn.zhxu.bs.convertor.B2MFieldConvertor;
import cn.zhxu.bs.convertor.DateFormatFieldConvertor;
import cn.zhxu.bs.dialect.Dialect;
import cn.zhxu.bs.group.GroupResolver;
import cn.zhxu.bs.implement.DefaultBeanReflector;
import cn.zhxu.bs.implement.DefaultBeanSearcher;
import cn.zhxu.bs.implement.DefaultMapSearcher;
import cn.zhxu.bs.implement.DefaultParamResolver;
import cn.zhxu.bs.implement.DefaultSqlExecutor;
import cn.zhxu.bs.solon.BeanSearcherProperties;
import cn.zhxu.bs.solon.NamedDataSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Inject;
import org.noear.solon.core.AopContext;

@Configuration
public class ConfigurationAfter {
    @Inject
    AopContext context;
    @Inject
    BeanSearcherProperties config;

    @Bean
    @Condition(onMissingBean=FieldOpPool.class)
    public FieldOpPool fieldOpPool(Dialect dialect) {
        List fieldOps = this.context.getBeansOfType(FieldOp.class);
        FieldOpPool pool = new FieldOpPool();
        this.ifAvailable(fieldOps, ops -> ops.forEach(arg_0 -> ((FieldOpPool)pool).addFieldOp(arg_0)));
        pool.setDialect(dialect);
        return pool;
    }

    @Bean
    @Condition(onMissingBean=ParamResolver.class)
    public ParamResolver paramResolver(PageExtractor pageExtractor, FieldOpPool fieldOpPool, GroupResolver groupResolver) {
        List paramFilters = this.context.getBeansOfType(ParamFilter.class);
        List convertors = this.context.getBeansOfType(FieldConvertor.ParamConvertor.class);
        DefaultParamResolver paramResolver = new DefaultParamResolver(convertors, paramFilters);
        paramResolver.setPageExtractor(pageExtractor);
        paramResolver.setFieldOpPool(fieldOpPool);
        BeanSearcherProperties.Params conf = this.config.getParams();
        paramResolver.setOperatorSuffix(conf.getOperatorKey());
        paramResolver.setIgnoreCaseSuffix(conf.getIgnoreCaseKey());
        paramResolver.setOrderName(conf.getOrder());
        paramResolver.setSortName(conf.getSort());
        paramResolver.setOrderByName(conf.getOrderBy());
        paramResolver.setSeparator(conf.getSeparator());
        paramResolver.setOnlySelectName(conf.getOnlySelect());
        paramResolver.setSelectExcludeName(conf.getSelectExclude());
        BeanSearcherProperties.Params.Group group = conf.getGroup();
        paramResolver.setGexprName(group.getExprName());
        paramResolver.setGroupSeparator(group.getSeparator());
        paramResolver.setGroupResolver(groupResolver);
        return paramResolver;
    }

    @Bean
    @Condition(onMissingBean=SqlExecutor.class)
    public SqlExecutor sqlExecutor() {
        DataSource dataSource = (DataSource)this.context.getBean(DataSource.class);
        List namedDataSources = this.context.getBeansOfType(NamedDataSource.class);
        SqlExecutor.SlowListener slowListener = (SqlExecutor.SlowListener)this.context.getBean(SqlExecutor.SlowListener.class);
        DefaultSqlExecutor executor = new DefaultSqlExecutor(dataSource);
        this.ifAvailable(namedDataSources, ndsList -> {
            for (NamedDataSource nds : ndsList) {
                executor.setDataSource(nds.getName(), nds.getDataSource());
            }
        });
        this.ifAvailable(slowListener, arg_0 -> ((DefaultSqlExecutor)executor).setSlowListener(arg_0));
        executor.setSlowSqlThreshold(this.config.getSql().getSlowSqlThreshold());
        return executor;
    }

    @Bean
    @Condition(onMissingBean=BeanReflector.class)
    public BeanReflector beanReflector() {
        List convertors = this.context.getBeansOfType(FieldConvertor.BFieldConvertor.class);
        if (convertors != null) {
            return new DefaultBeanReflector(convertors);
        }
        return new DefaultBeanReflector();
    }

    @Bean
    @Condition(onMissingBean=BeanSearcher.class, onProperty="${bean-searcher.use-bean-searcher:true}=true")
    public BeanSearcher beanSearcher(MetaResolver metaResolver, ParamResolver paramResolver, SqlResolver sqlResolver, SqlExecutor sqlExecutor, BeanReflector beanReflector) {
        List interceptors = this.context.getBeansOfType(SqlInterceptor.class);
        List processors = this.context.getBeansOfType(ResultFilter.class);
        DefaultBeanSearcher searcher = new DefaultBeanSearcher();
        searcher.setMetaResolver(metaResolver);
        searcher.setParamResolver(paramResolver);
        searcher.setSqlResolver(sqlResolver);
        searcher.setSqlExecutor(sqlExecutor);
        searcher.setBeanReflector(beanReflector);
        this.ifAvailable(interceptors, arg_0 -> ((DefaultBeanSearcher)searcher).setInterceptors(arg_0));
        this.ifAvailable(processors, arg_0 -> ((DefaultBeanSearcher)searcher).setResultFilters(arg_0));
        return searcher;
    }

    @Bean
    @Condition(onMissingBean=B2MFieldConvertor.class, onProperty="${bean-searcher.field-convertor.use-b2-m}=true")
    public B2MFieldConvertor b2mFieldConvertor() {
        List convertors = this.context.getBeansOfType(FieldConvertor.BFieldConvertor.class);
        if (convertors != null) {
            return new B2MFieldConvertor(convertors);
        }
        return new B2MFieldConvertor(Collections.emptyList());
    }

    @Bean
    @Condition(onMissingBean=MapSearcher.class, onProperty="${bean-searcher.use-map-searcher:true}=true")
    public MapSearcher mapSearcher(MetaResolver metaResolver, ParamResolver paramResolver, SqlResolver sqlResolver, SqlExecutor sqlExecutor) {
        List convertors = this.context.getBeansOfType(FieldConvertor.MFieldConvertor.class);
        List interceptors = this.context.getBeansOfType(SqlInterceptor.class);
        List resultFilters = this.context.getBeansOfType(ResultFilter.class);
        DefaultMapSearcher searcher = new DefaultMapSearcher();
        searcher.setMetaResolver(metaResolver);
        searcher.setParamResolver(paramResolver);
        searcher.setSqlResolver(sqlResolver);
        searcher.setSqlExecutor(sqlExecutor);
        if (convertors != null) {
            ArrayList newList = new ArrayList(convertors);
            newList.sort((o1, o2) -> {
                if (o1 instanceof DateFormatFieldConvertor) {
                    return -1;
                }
                if (o2 instanceof DateFormatFieldConvertor) {
                    return 1;
                }
                return 0;
            });
            searcher.setConvertors(newList);
        }
        this.ifAvailable(interceptors, arg_0 -> ((DefaultMapSearcher)searcher).setInterceptors(arg_0));
        this.ifAvailable(resultFilters, arg_0 -> ((DefaultMapSearcher)searcher).setResultFilters(arg_0));
        return searcher;
    }

    private <T> void ifAvailable(T provider, Consumer<T> consumer) {
        if (provider != null) {
            consumer.accept(provider);
        }
    }
}

