/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.label;

import cn.zhxu.bs.label.LabelKey;
import java.lang.reflect.Field;
import java.util.Map;

public class LabelField {
    private final Field field;
    private final Field idField;

    public LabelField(Field field, Field idField) {
        this.field = field;
        this.idField = idField;
    }

    public Object id(Object data) {
        if (data instanceof Map) {
            return ((Map)data).get(this.idField.getName());
        }
        try {
            return this.idField.get(data);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void setLabel(Object data, String label) {
        if (data instanceof Map) {
            ((Map)data).put(this.field.getName(), label);
            return;
        }
        try {
            this.field.set(data, label);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static class KEY {
        private final String key;
        private final Field field;
        private final Field idField;

        public KEY(Field field, Field idField, String key) {
            this.field = field;
            this.idField = idField;
            this.key = key;
        }

        public LabelKey key() {
            Class<?> idType = this.idField.getType();
            if (idType == Boolean.TYPE) {
                return new LabelKey(this.key, Boolean.class);
            }
            if (idType == Byte.TYPE) {
                return new LabelKey(this.key, Byte.class);
            }
            if (idType == Character.TYPE) {
                return new LabelKey(this.key, Character.class);
            }
            if (idType == Short.TYPE) {
                return new LabelKey(this.key, Short.class);
            }
            if (idType == Integer.TYPE) {
                return new LabelKey(this.key, Integer.class);
            }
            if (idType == Float.TYPE) {
                return new LabelKey(this.key, Float.class);
            }
            if (idType == Long.TYPE) {
                return new LabelKey(this.key, Long.class);
            }
            if (idType == Double.TYPE) {
                return new LabelKey(this.key, Double.class);
            }
            return new LabelKey(this.key, idType);
        }

        public LabelField field() {
            return new LabelField(this.field, this.idField);
        }
    }
}

