/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.label;

import cn.zhxu.bs.BeanMeta;
import cn.zhxu.bs.ResultFilter;
import cn.zhxu.bs.SearchException;
import cn.zhxu.bs.SearchResult;
import cn.zhxu.bs.label.Label;
import cn.zhxu.bs.label.LabelField;
import cn.zhxu.bs.label.LabelFor;
import cn.zhxu.bs.label.LabelKey;
import cn.zhxu.bs.label.LabelLoader;
import cn.zhxu.bs.param.FetchType;
import cn.zhxu.bs.util.AnnoUtils;
import cn.zhxu.bs.util.StringUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class LabelResultFilter
implements ResultFilter {
    private final List<LabelLoader<?>> labelLoaders;
    private final Map<Class<?>, Map<LabelKey, List<LabelField>>> cache = new ConcurrentHashMap();

    public LabelResultFilter() {
        this.labelLoaders = new ArrayList();
    }

    public LabelResultFilter(List<LabelLoader<?>> labelLoaders) {
        this.labelLoaders = new ArrayList(labelLoaders);
    }

    public <T> SearchResult<T> doBeanFilter(SearchResult<T> result, BeanMeta<T> beanMeta, Map<String, Object> paraMap, FetchType fetchType) {
        return this.processResult(result, beanMeta);
    }

    public <T> SearchResult<Map<String, Object>> doMapFilter(SearchResult<Map<String, Object>> result, BeanMeta<T> beanMeta, Map<String, Object> paraMap, FetchType fetchType) {
        return this.processResult(result, beanMeta);
    }

    public <T> SearchResult<T> processResult(SearchResult<T> result, BeanMeta<?> beanMeta) {
        List dataList = result.getDataList();
        if (dataList != null && !dataList.isEmpty()) {
            this.processDataList(beanMeta.getBeanClass(), dataList);
        }
        return result;
    }

    public void processDataList(Class<?> beanClass, List<?> dataList) {
        this.loadLabelFieldMap(beanClass).forEach((key, fields) -> {
            List<Object> ids = dataList.stream().flatMap(data -> fields.stream().map(field -> field.id(data))).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (ids.isEmpty()) {
                return;
            }
            List<Label<?>> labels = this.loadLabels(beanClass, (LabelKey)key, ids);
            if (labels.isEmpty()) {
                return;
            }
            for (LabelField field : fields) {
                this.fillLabels(field, dataList, labels);
            }
        });
    }

    protected void fillLabels(LabelField field, List<?> dataList, List<Label<?>> labels) {
        block0: for (Object data : dataList) {
            Object id = field.id(data);
            for (Label<?> label : labels) {
                if (!Objects.equals(label.getId(), id)) continue;
                field.setLabel(data, label.getLabel());
                continue block0;
            }
        }
    }

    protected List<Label<?>> loadLabels(Class<?> beanClass, LabelKey key, List<Object> ids) {
        for (LabelLoader<?> labelLoader : this.labelLoaders) {
            if (!key.supports(labelLoader)) continue;
            LabelLoader<?> loader = labelLoader;
            List<Label<?>> labels = loader.load(key.getKey(), ids);
            return labels;
        }
        throw new SearchException("Can not load labels for " + key + " on " + beanClass + ", please add a LabelLoader for it.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<LabelKey, List<LabelField>> loadLabelFieldMap(Class<?> beanClass) {
        Map<LabelKey, List<LabelField>> fieldsMap = this.cache.get(beanClass);
        if (fieldsMap != null) {
            return fieldsMap;
        }
        Map<Class<?>, Map<LabelKey, List<LabelField>>> map = this.cache;
        synchronized (map) {
            Map<LabelKey, List<LabelField>> map2 = this.cache.get(beanClass);
            if (map2 == null) {
                map2 = this.resolveLabelFieldKeys(beanClass).stream().collect(Collectors.groupingBy(LabelField.KEY::key, Collectors.mapping(LabelField.KEY::field, Collectors.toList())));
                this.cache.put(beanClass, map2);
            }
            return map2;
        }
    }

    protected List<LabelField.KEY> resolveLabelFieldKeys(Class<?> beanClass) {
        ArrayList<LabelField.KEY> fieldList = new ArrayList<LabelField.KEY>();
        HashSet<String> fieldNames = new HashSet<String>();
        for (Class<?> thisClass = beanClass; thisClass != Object.class; thisClass = thisClass.getSuperclass()) {
            for (Field field : thisClass.getDeclaredFields()) {
                String name = field.getName();
                if (field.isSynthetic() || Modifier.isStatic(field.getModifiers()) || fieldNames.contains(name)) continue;
                LabelFor labelFor = (LabelFor)AnnoUtils.getAnnotation((AnnotatedElement)field, LabelFor.class);
                if (labelFor != null) {
                    try {
                        Field idField = this.requireField(beanClass, labelFor.value());
                        idField.setAccessible(true);
                        field.setAccessible(true);
                        String key = labelFor.key();
                        fieldList.add(new LabelField.KEY(field, idField, StringUtils.isBlank((String)key) ? field.getName() : key));
                    }
                    catch (NoSuchFieldException e) {
                        throw new SearchException("The field [" + labelFor.value() + "] is not found in [" + beanClass.getName() + "]", (Throwable)e);
                    }
                }
                fieldNames.add(name);
            }
        }
        return fieldList;
    }

    protected Field requireField(Class<?> beanClass, String fieldName) throws NoSuchFieldException {
        try {
            return beanClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = beanClass.getSuperclass();
            if (superClass == null || superClass == Object.class) {
                throw e;
            }
            return this.requireField(superClass, fieldName);
        }
    }

    public void addLabelLoader(LabelLoader<?> labelLoader) {
        this.labelLoaders.add(labelLoader);
    }

    public void removeLabelLoader(LabelLoader<?> labelLoader) {
        this.labelLoaders.remove(labelLoader);
    }

    public void clearLabelLoaders() {
        this.labelLoaders.clear();
    }

    public void clearCache() {
        this.cache.clear();
    }
}

