/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.label;

import cn.zhxu.bs.label.LabelLoader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;

public class LabelKey {
    private final String key;
    private final Class<?> idType;

    public LabelKey(String key, Class<?> idType) {
        this.key = key;
        this.idType = idType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LabelKey labelKey = (LabelKey)o;
        return Objects.equals(this.key, labelKey.key) && Objects.equals(this.idType, labelKey.idType);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.idType);
    }

    public String getKey() {
        return this.key;
    }

    public boolean supports(LabelLoader<?> labelLoader) {
        return labelLoader.supports(this.key) && this.match(labelLoader.getClass());
    }

    private boolean match(Class<?> loaderClass) {
        Type type = loaderClass.getGenericInterfaces()[0];
        if (type instanceof ParameterizedType) {
            Type argType = ((ParameterizedType)type).getActualTypeArguments()[0];
            return this.matchType(argType);
        }
        return false;
    }

    public boolean matchType(Type argType) {
        if (argType == this.idType) {
            return true;
        }
        if (argType instanceof Class) {
            return ((Class)argType).isAssignableFrom(this.idType);
        }
        if (argType instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)argType).getRawType();
            return this.matchType(rawType);
        }
        return false;
    }

    public String toString() {
        return "{key=" + this.key + ", idType=" + this.idType + '}';
    }
}

