/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.label;

import cn.zhxu.bs.label.Label;
import cn.zhxu.bs.label.LabelLoader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class EnumLabelLoader
implements LabelLoader<Enum<?>> {
    private final String keyPrefix;
    private final Map<Class<Enum<?>>, Function<Enum<?>, String>> labelFunMap = new ConcurrentHashMap();

    public EnumLabelLoader() {
        this("");
    }

    public EnumLabelLoader(String keyPrefix) {
        this.keyPrefix = Objects.requireNonNull(keyPrefix);
    }

    @Override
    public boolean supports(String key) {
        return key != null && key.startsWith(this.keyPrefix);
    }

    @Override
    public List<Label<Enum<?>>> load(String key, List<Enum<?>> enums) {
        return enums.stream().map(e -> {
            Function<Enum<?>, String> fun = this.labelFunMap.get(e.getClass());
            String label = fun != null ? fun.apply((Enum<?>)e) : null;
            return label != null ? new Label<Enum>((Enum)e, label) : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public <T extends Enum<?>> EnumLabelLoader with(Class<T> enumType, Function<T, String> labelFun) {
        this.labelFunMap.put(enumType, labelFun);
        return this;
    }

    public void clear() {
        this.labelFunMap.clear();
    }
}

