/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.ex;

import cn.zhxu.bs.ex.Export;
import cn.zhxu.bs.ex.ExportField;
import cn.zhxu.bs.ex.ExportFieldResolver;
import cn.zhxu.bs.ex.Expresser;
import cn.zhxu.bs.ex.Formatter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultExportFieldResolver
implements ExportFieldResolver {
    private final Map<Class<?>, List<ExportField>> cache = new ConcurrentHashMap();
    private final Expresser expresser;
    private final Formatter formatter;

    public DefaultExportFieldResolver() {
        this(null, Formatter.DEFAULT);
    }

    public DefaultExportFieldResolver(Expresser expresser) {
        this(expresser, Formatter.DEFAULT);
    }

    public DefaultExportFieldResolver(Expresser expresser, Formatter formatter) {
        this.expresser = expresser;
        this.formatter = formatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ExportField> resolve(Class<?> beanClass) {
        List<ExportField> exportFields = this.cache.get(beanClass);
        if (exportFields != null) {
            return exportFields;
        }
        Map<Class<?>, List<ExportField>> map = this.cache;
        synchronized (map) {
            List<ExportField> fields = this.cache.get(beanClass);
            if (fields == null) {
                fields = this.resolveFields(beanClass);
                this.cache.put(beanClass, fields);
            }
            return fields;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        Map<Class<?>, List<ExportField>> map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }

    public List<ExportField> resolveFields(Class<?> clazz) {
        ArrayList<ExportField> exFields = new ArrayList<ExportField>();
        HashSet<String> names = new HashSet<String>();
        while (clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                ExportField exField;
                int modifiers = field.getModifiers();
                String name = field.getName();
                if (field.isSynthetic() || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || names.contains(name) || (exField = this.toExportField(field)) == null) continue;
                field.setAccessible(true);
                exFields.add(exField);
                names.add(name);
            }
            clazz = clazz.getSuperclass();
        }
        exFields.sort(Comparator.comparingInt(ExportField::getExIdx));
        return exFields;
    }

    public ExportField toExportField(Field field) {
        Export export = field.getAnnotation(Export.class);
        if (export == null) {
            return null;
        }
        return new ExportField(this.expresser, this.formatter, field, export.name(), export.idx(), export.expr(), export.format(), export.onlyIf());
    }

    public Expresser getExpresser() {
        return this.expresser;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }
}

