/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.ex;

import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.ex.BeanExporter;
import cn.zhxu.bs.ex.DefaultExportFieldResolver;
import cn.zhxu.bs.ex.DelayPolicy;
import cn.zhxu.bs.ex.ExportException;
import cn.zhxu.bs.ex.ExportField;
import cn.zhxu.bs.ex.ExportFieldResolver;
import cn.zhxu.bs.ex.FileNamer;
import cn.zhxu.bs.ex.FileWriter;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class DefaultBeanExporter
implements BeanExporter {
    private final BeanSearcher beanSearcher;
    private final int startPage;
    private final int defaultBatchSize;
    private final Duration batchDelay;
    private final int maxExportingThreads;
    private final int maxThreads;
    private final AtomicInteger exportingThreads = new AtomicInteger();
    private final AtomicInteger threads = new AtomicInteger();
    private ExportFieldResolver fieldResolver = new DefaultExportFieldResolver();
    private FileWriter.Factory fileWriterFactory;
    private FileNamer fileNamer = FileNamer.SELF;
    private DelayPolicy delayPolicy = new DelayPolicy.RandomInflate();

    public DefaultBeanExporter(BeanSearcher beanSearcher) {
        this(beanSearcher, 10, 30);
    }

    public DefaultBeanExporter(BeanSearcher beanSearcher, int maxExportingThreads, int maxThreads) {
        this(beanSearcher, 0, 1000, Duration.ofMillis(100L), maxExportingThreads, maxThreads);
    }

    public DefaultBeanExporter(BeanSearcher beanSearcher, int startPage, int defaultBatchSize, Duration batchDelay, int maxExportingThreads, int maxThreads) {
        this.beanSearcher = Objects.requireNonNull(beanSearcher);
        this.startPage = startPage;
        this.defaultBatchSize = defaultBatchSize;
        this.batchDelay = Objects.requireNonNull(batchDelay);
        this.maxExportingThreads = maxExportingThreads;
        this.maxThreads = maxThreads;
    }

    @Override
    public <T> void export(String name, Class<T> beanClass) throws IOException {
        this.export(name, beanClass, null, this.defaultBatchSize, null);
    }

    @Override
    public <T> void export(String name, Class<T> beanClass, int batchSize) throws IOException {
        this.export(name, beanClass, null, batchSize, null);
    }

    @Override
    public <T> void export(String name, Class<T> beanClass, Map<String, Object> paraMap) throws IOException {
        this.export(name, beanClass, paraMap, this.defaultBatchSize, null);
    }

    @Override
    public <T> void export(String name, Class<T> beanClass, Map<String, Object> paraMap, int batchSize) throws IOException {
        this.export(name, beanClass, paraMap, batchSize, null);
    }

    @Override
    public <T> void export(String name, Class<T> beanClass, Function<List<T>, List<T>> mapper) throws IOException {
        this.export(name, beanClass, null, this.defaultBatchSize, mapper);
    }

    @Override
    public <T> void export(String name, Class<T> beanClass, int batchSize, Function<List<T>, List<T>> mapper) throws IOException {
        this.export(name, beanClass, null, batchSize, mapper);
    }

    @Override
    public <T> void export(String name, Class<T> beanClass, Map<String, Object> paraMap, Function<List<T>, List<T>> mapper) throws IOException {
        this.export(name, beanClass, paraMap, this.defaultBatchSize, mapper);
    }

    @Override
    public <T> void export(String name, Class<T> beanClass, Map<String, Object> paraMap, int batchSize, Function<List<T>, List<T>> mapper) throws IOException {
        if (name == null) {
            throw new ExportException("You must set a name before exporting.");
        }
        FileWriter.Factory factory = this.fileWriterFactory;
        if (factory == null) {
            throw new ExportException("You must set a fileWriterFactory before exporting.");
        }
        this.export(factory.create(this.fileNamer.filename(name)), beanClass, paraMap, batchSize, mapper);
    }

    @Override
    public <T> void export(FileWriter writer, Class<T> beanClass) throws IOException {
        this.export(writer, beanClass, null, this.defaultBatchSize, null);
    }

    @Override
    public <T> void export(FileWriter writer, Class<T> beanClass, int batchSize) throws IOException {
        this.export(writer, beanClass, null, batchSize, null);
    }

    @Override
    public <T> void export(FileWriter writer, Class<T> beanClass, Map<String, Object> paraMap) throws IOException {
        this.export(writer, beanClass, paraMap, this.defaultBatchSize, null);
    }

    @Override
    public <T> void export(FileWriter writer, Class<T> beanClass, Map<String, Object> paraMap, int batchSize) throws IOException {
        this.export(writer, beanClass, paraMap, batchSize, null);
    }

    @Override
    public <T> void export(FileWriter writer, Class<T> beanClass, Function<List<T>, List<T>> mapper) throws IOException {
        this.export(writer, beanClass, null, this.defaultBatchSize, mapper);
    }

    @Override
    public <T> void export(FileWriter writer, Class<T> beanClass, int batchSize, Function<List<T>, List<T>> mapper) throws IOException {
        this.export(writer, beanClass, null, batchSize, mapper);
    }

    @Override
    public <T> void export(FileWriter writer, Class<T> beanClass, Map<String, Object> paraMap, Function<List<T>, List<T>> mapper) throws IOException {
        this.export(writer, beanClass, paraMap, this.defaultBatchSize, mapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void export(FileWriter writer, Class<T> beanClass, Map<String, Object> paraMap, int batchSize, Function<List<T>, List<T>> mapper) throws IOException {
        if (writer == null) {
            throw new ExportException("You must set a fileWriter before exporting.");
        }
        if (batchSize < 1) {
            throw new ExportException("The batchSize must be greater than 0.");
        }
        if (this.threads.get() >= this.maxThreads) {
            writer.onTooManyRequests();
            return;
        }
        try {
            this.threads.incrementAndGet();
            List<ExportField> fields = this.fieldResolver.resolve(beanClass);
            writer.writeStart(fields);
            while (this.exportingThreads.get() >= this.maxExportingThreads) {
                this.tryDelay(10L);
            }
            try {
                this.exportingThreads.incrementAndGet();
                this.loadDataAndExportToWriter(writer, fields, beanClass, paraMap != null ? paraMap : new HashMap<String, Object>(), batchSize, mapper);
                writer.writeStop(fields);
            }
            finally {
                this.exportingThreads.decrementAndGet();
            }
        }
        finally {
            this.threads.decrementAndGet();
        }
    }

    protected <T> void loadDataAndExportToWriter(FileWriter writer, List<ExportField> fields, Class<T> beanClass, Map<String, Object> paraMap, int batchSize, Function<List<T>, List<T>> mapper) throws IOException {
        MapBuilder builder = MapUtils.builder(paraMap);
        int pageNum = this.startPage;
        while (true) {
            List<T> list = this.beanSearcher.searchList(beanClass, builder.page((long)pageNum, batchSize).build());
            writer.writeAndFlush(fields, mapper != null ? mapper.apply(list) : list);
            if (list.size() < batchSize) break;
            this.tryDelay(this.delayPolicy.batchDelay((int)this.batchDelay.toMillis(), this.exportingThreads.get(), this.maxExportingThreads));
            ++pageNum;
        }
    }

    private void tryDelay(long millis) {
        if (millis == 0L) {
            return;
        }
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public BeanSearcher getBeanSearcher() {
        return this.beanSearcher;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public int getDefaultBatchSize() {
        return this.defaultBatchSize;
    }

    public Duration getBatchDelay() {
        return this.batchDelay;
    }

    public int getMaxExportingThreads() {
        return this.maxExportingThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public AtomicInteger getExportingThreads() {
        return this.exportingThreads;
    }

    public AtomicInteger getThreads() {
        return this.threads;
    }

    public ExportFieldResolver getFieldResolver() {
        return this.fieldResolver;
    }

    public void setFieldResolver(ExportFieldResolver fieldResolver) {
        this.fieldResolver = Objects.requireNonNull(fieldResolver);
    }

    public FileWriter.Factory getFileWriterFactory() {
        return this.fileWriterFactory;
    }

    public void setFileWriterFactory(FileWriter.Factory fileWriterFactory) {
        this.fileWriterFactory = fileWriterFactory;
    }

    public FileNamer getFileNamer() {
        return this.fileNamer;
    }

    public void setFileNamer(FileNamer fileNamer) {
        this.fileNamer = Objects.requireNonNull(fileNamer);
    }

    public DelayPolicy getDelayPolicy() {
        return this.delayPolicy;
    }

    public void setDelayPolicy(DelayPolicy delayPolicy) {
        this.delayPolicy = Objects.requireNonNull(delayPolicy);
    }
}

