/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.ex;

import cn.zhxu.bs.ex.ExportException;
import cn.zhxu.bs.ex.ExportField;
import cn.zhxu.bs.ex.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class CsvFileWriter
implements FileWriter {
    public static final String COMMA = ",";
    public static final String CRLF = "\r\n";
    public static final String FILE_EXT = ".csv";
    private final Writer writer;

    public CsvFileWriter(Writer writer) {
        this.writer = writer;
    }

    public CsvFileWriter(OutputStream output) {
        this.writer = new OutputStreamWriter(output, StandardCharsets.UTF_8);
    }

    public static String withFileExt(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("filename can not be null.");
        }
        return filename.endsWith(FILE_EXT) ? filename : filename + FILE_EXT;
    }

    @Override
    public void writeStart(List<ExportField> fields) throws IOException {
        int size = fields.size();
        for (int col = 0; col < size; ++col) {
            String text = fields.get(col).getExName();
            this.writer.write(this.escape(text));
            if (col >= size - 1) continue;
            this.writer.write(COMMA);
        }
        this.writer.write(CRLF);
        this.writer.flush();
    }

    @Override
    public void writeAndFlush(List<ExportField> fields, List<?> dataList) throws IOException {
        int size = fields.size();
        for (Object data : dataList) {
            for (int col = 0; col < size; ++col) {
                String text = fields.get(col).text(data);
                this.writer.write(this.escape(text));
                if (col >= size - 1) continue;
                this.writer.write(COMMA);
            }
            this.writer.write(CRLF);
        }
        this.writer.flush();
    }

    public void writeAndFlush(String content) throws IOException {
        if (content != null) {
            this.writer.write(content);
        }
        this.writer.flush();
    }

    @Override
    public void writeStop(List<ExportField> fields) {
    }

    @Override
    public void onTooManyRequests() throws IOException {
        throw new ExportException.TooManyRequests("Too many requests.");
    }

    protected String escape(String text) {
        if (text.contains(COMMA)) {
            return "\"" + text.replaceAll("\"", "\"\"") + "\"";
        }
        return text;
    }

    public Writer getWriter() {
        return this.writer;
    }
}

