/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.ex;

import cn.zhxu.bs.ex.ExportException;
import cn.zhxu.bs.ex.Expresser;
import cn.zhxu.bs.ex.Formatter;
import cn.zhxu.bs.util.StringUtils;
import java.lang.reflect.Field;

public class ExportField {
    private final Expresser expresser;
    private final Formatter formatter;
    private final Field field;
    private final String exName;
    private final int exIdx;
    private final String expr;
    private final String format;

    public ExportField(Expresser expresser, Formatter formatter, Field field, String exName, int exIdx, String expr, String format) {
        this.expresser = expresser;
        this.formatter = formatter;
        this.field = field;
        this.exName = exName;
        this.exIdx = exIdx;
        this.expr = expr;
        this.format = format;
    }

    public String text(Object obj) {
        Object value = this.evaluate(obj, this.value(obj));
        if (StringUtils.isBlank((String)this.format) || this.formatter == null) {
            return value == null ? "" : value.toString();
        }
        return this.formatter.format(this.format, value);
    }

    public Object value(Object obj) {
        try {
            return this.field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new ExportException("Can not access " + this.field.getName(), e);
        }
    }

    public Object evaluate(Object obj, Object value) {
        if (this.expresser == null || StringUtils.isBlank((String)this.expr)) {
            return value;
        }
        try {
            return this.expresser.evaluate(this.expr, obj, value);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not compute the expr [" + this.expr + "]", e);
        }
    }

    public Expresser getExpresser() {
        return this.expresser;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public Field getField() {
        return this.field;
    }

    public int getExIdx() {
        return this.exIdx;
    }

    public String getExName() {
        return this.exName;
    }

    public String getExpr() {
        return this.expr;
    }

    public String getFormat() {
        return this.format;
    }
}

