/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.ex;

import cn.zhxu.bs.ex.Export;
import cn.zhxu.bs.ex.ExportField;
import cn.zhxu.bs.ex.ExportFieldResolver;
import cn.zhxu.bs.ex.Expresser;
import cn.zhxu.bs.ex.Formatter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class DefaultExportFieldResolver
implements ExportFieldResolver {
    private final Expresser expresser;
    private final Formatter formatter;

    public DefaultExportFieldResolver() {
        this(null, Formatter.DEFAULT);
    }

    public DefaultExportFieldResolver(Expresser expresser) {
        this(expresser, Formatter.DEFAULT);
    }

    public DefaultExportFieldResolver(Expresser expresser, Formatter formatter) {
        this.expresser = expresser;
        this.formatter = formatter;
    }

    @Override
    public List<ExportField> resolve(Class<?> clazz) {
        ArrayList<ExportField> exFields = new ArrayList<ExportField>();
        HashSet<String> names = new HashSet<String>();
        while (clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                ExportField exField;
                int modifiers = field.getModifiers();
                String name = field.getName();
                if (field.isSynthetic() || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || names.contains(name) || (exField = this.toExportField(field)) == null) continue;
                field.setAccessible(true);
                exFields.add(exField);
                names.add(name);
            }
            clazz = clazz.getSuperclass();
        }
        exFields.sort(Comparator.comparingInt(ExportField::getExIdx));
        return exFields;
    }

    public ExportField toExportField(Field field) {
        Export export = field.getAnnotation(Export.class);
        if (export == null) {
            return null;
        }
        return new ExportField(this.expresser, this.formatter, field, export.name(), export.idx(), export.expr(), export.format());
    }

    public Expresser getExpresser() {
        return this.expresser;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }
}

