/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.boot;

import cn.zhxu.bs.BeanReflector;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.DbMapping;
import cn.zhxu.bs.FieldConvertor;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOpPool;
import cn.zhxu.bs.MapSearcher;
import cn.zhxu.bs.MetaResolver;
import cn.zhxu.bs.PageExtractor;
import cn.zhxu.bs.ParamFilter;
import cn.zhxu.bs.ParamResolver;
import cn.zhxu.bs.ResultFilter;
import cn.zhxu.bs.SnippetResolver;
import cn.zhxu.bs.SqlExecutor;
import cn.zhxu.bs.SqlInterceptor;
import cn.zhxu.bs.SqlResolver;
import cn.zhxu.bs.boot.BeanSearcherProperties;
import cn.zhxu.bs.boot.DataSourceDialect;
import cn.zhxu.bs.boot.IllegalConfigException;
import cn.zhxu.bs.boot.NamedDataSource;
import cn.zhxu.bs.convertor.B2MFieldConvertor;
import cn.zhxu.bs.convertor.BoolFieldConvertor;
import cn.zhxu.bs.convertor.BoolNumFieldConvertor;
import cn.zhxu.bs.convertor.BoolParamConvertor;
import cn.zhxu.bs.convertor.DateFieldConvertor;
import cn.zhxu.bs.convertor.DateFormatFieldConvertor;
import cn.zhxu.bs.convertor.DateParamConvertor;
import cn.zhxu.bs.convertor.DateTimeParamConvertor;
import cn.zhxu.bs.convertor.EnumFieldConvertor;
import cn.zhxu.bs.convertor.JsonFieldConvertor;
import cn.zhxu.bs.convertor.ListFieldConvertor;
import cn.zhxu.bs.convertor.NumberFieldConvertor;
import cn.zhxu.bs.convertor.NumberParamConvertor;
import cn.zhxu.bs.convertor.StrNumFieldConvertor;
import cn.zhxu.bs.convertor.TimeFieldConvertor;
import cn.zhxu.bs.convertor.TimeParamConvertor;
import cn.zhxu.bs.dialect.Dialect;
import cn.zhxu.bs.dialect.DynamicDialect;
import cn.zhxu.bs.dialect.DynamicDialectSupport;
import cn.zhxu.bs.dialect.MySqlDialect;
import cn.zhxu.bs.dialect.OracleDialect;
import cn.zhxu.bs.dialect.PostgreSqlDialect;
import cn.zhxu.bs.dialect.SqlServerDialect;
import cn.zhxu.bs.filter.SizeLimitParamFilter;
import cn.zhxu.bs.group.DefaultGroupResolver;
import cn.zhxu.bs.group.DefaultParserFactory;
import cn.zhxu.bs.group.ExprParser;
import cn.zhxu.bs.group.GroupPair;
import cn.zhxu.bs.group.GroupResolver;
import cn.zhxu.bs.implement.DefaultBeanReflector;
import cn.zhxu.bs.implement.DefaultBeanSearcher;
import cn.zhxu.bs.implement.DefaultDbMapping;
import cn.zhxu.bs.implement.DefaultMapSearcher;
import cn.zhxu.bs.implement.DefaultMetaResolver;
import cn.zhxu.bs.implement.DefaultParamResolver;
import cn.zhxu.bs.implement.DefaultSqlExecutor;
import cn.zhxu.bs.implement.DefaultSqlResolver;
import cn.zhxu.bs.implement.GroupPairResolver;
import cn.zhxu.bs.implement.PageOffsetExtractor;
import cn.zhxu.bs.implement.PageSizeExtractor;
import cn.zhxu.bs.util.Cache;
import cn.zhxu.bs.util.LRUCache;
import cn.zhxu.xjson.JsonKit;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableConfigurationProperties(value={BeanSearcherProperties.class})
public class BeanSearcherAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={PageExtractor.class})
    public PageExtractor pageExtractor(BeanSearcherProperties config) {
        PageSizeExtractor extractor;
        PageSizeExtractor p;
        BeanSearcherProperties.Params.Pagination conf = config.getParams().getPagination();
        String type = conf.getType();
        if ("page".equals(type)) {
            p = new PageSizeExtractor();
            p.setPageName(conf.getPage());
            extractor = p;
        } else if ("offset".equals(type)) {
            p = new PageOffsetExtractor();
            p.setOffsetName(conf.getOffset());
            extractor = p;
        } else {
            throw new IllegalConfigException("Invalid config: [bean-searcher.params.pagination.type: " + type + "], only 'page' / 'offset' allowed.");
        }
        int defaultSize = conf.getDefaultSize();
        int maxAllowedSize = conf.getMaxAllowedSize();
        long maxAllowedOffset = conf.getMaxAllowedOffset();
        if (defaultSize > maxAllowedSize) {
            throw new IllegalConfigException("Invalid config: [bean-searcher.params.pagination.default-size: " + defaultSize + "] can not greater than [bean-searcher.params.pagination.max-allowed-size: " + maxAllowedSize + "].");
        }
        if (defaultSize < 1) {
            throw new IllegalConfigException("Invalid config: [bean-searcher.params.pagination.default-size: " + defaultSize + "] must greater equal 1");
        }
        if (maxAllowedOffset < 1L) {
            throw new IllegalConfigException("Invalid config: [bean-searcher.params.pagination.max-allowed-offset: " + maxAllowedOffset + "] must greater equal 1");
        }
        extractor.setMaxAllowedSize(maxAllowedSize);
        extractor.setMaxAllowedOffset(maxAllowedOffset);
        extractor.setDefaultSize(defaultSize);
        extractor.setSizeName(conf.getSize());
        extractor.setStart(conf.getStart());
        return extractor;
    }

    @Bean
    @ConditionalOnMissingBean(value={Dialect.class})
    public Dialect dialect(BeanSearcherProperties config) {
        BeanSearcherProperties.Sql.Dialect dialect = config.getSql().getDialect();
        if (dialect == null) {
            throw new IllegalConfigException("Invalid config: [bean-searcher.sql.dialect] can not be null.");
        }
        switch (dialect) {
            case MySQL: {
                return new MySqlDialect();
            }
            case Oracle: {
                return new OracleDialect();
            }
            case PostgreSQL: 
            case PgSQL: {
                return new PostgreSqlDialect();
            }
            case SqlServer: {
                return new SqlServerDialect();
            }
        }
        throw new IllegalConfigException("Invalid config: [bean-searcher.sql.dialect: " + (Object)((Object)dialect) + "] only `MySql` / `Oracle` / `PostgreSQL` / `SqlServer` allowed. Please see https://bs.zhxu.cn/guide/latest/advance.html#sql-%E6%96%B9%E8%A8%80%EF%BC%88dialect%EF%BC%89 for help.");
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.sql.dialect-dynamic"}, havingValue="true")
    @ConditionalOnMissingBean(value={DynamicDialect.class})
    public DynamicDialect dynamicDialect(Dialect dialect, ObjectProvider<List<DataSourceDialect>> dialects) {
        DynamicDialect dynamicDialect = new DynamicDialect();
        dynamicDialect.setDefaultDialect(dialect);
        this.ifAvailable(dialects, list -> list.forEach(item -> dynamicDialect.put(item.getDataSource(), item.getDialect())));
        return dynamicDialect;
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.sql.dialect-dynamic"}, havingValue="true")
    @ConditionalOnMissingBean(value={DynamicDialectSupport.class})
    public DynamicDialectSupport dynamicDialectSupport() {
        return new DynamicDialectSupport();
    }

    @Bean
    @ConditionalOnMissingBean(value={FieldOpPool.class})
    public FieldOpPool fieldOpPool(Dialect dialect, ObjectProvider<List<FieldOp>> fieldOps) {
        FieldOpPool pool = new FieldOpPool();
        this.ifAvailable(fieldOps, ops -> ops.forEach(arg_0 -> ((FieldOpPool)pool).addFieldOp(arg_0)));
        pool.setDialect(dialect);
        return pool;
    }

    @Bean
    @ConditionalOnMissingBean(value={ExprParser.Factory.class})
    public ExprParser.Factory parserFactory() {
        return new DefaultParserFactory();
    }

    @Bean
    @ConditionalOnMissingBean(value={GroupResolver.class})
    public GroupResolver groupResolver(BeanSearcherProperties config, ExprParser.Factory parserFactory) {
        DefaultGroupResolver groupResolver = new DefaultGroupResolver();
        BeanSearcherProperties.Params.Group conf = config.getParams().getGroup();
        groupResolver.setEnabled(conf.isEnable());
        groupResolver.setCache((Cache)new LRUCache(conf.getCacheSize()));
        groupResolver.setMaxExprLength(conf.getMaxExprLength());
        groupResolver.setParserFactory(parserFactory);
        return groupResolver;
    }

    @Bean
    @ConditionalOnMissingBean(value={BoolParamConvertor.class})
    public BoolParamConvertor boolParamConvertor() {
        return new BoolParamConvertor();
    }

    @Bean
    @ConditionalOnMissingBean(value={NumberParamConvertor.class})
    public NumberParamConvertor numberParamConvertor() {
        return new NumberParamConvertor();
    }

    @Bean
    @ConditionalOnMissingBean(value={DateParamConvertor.class})
    public DateParamConvertor dateParamConvertor() {
        return new DateParamConvertor();
    }

    @Bean
    @ConditionalOnMissingBean(value={TimeParamConvertor.class})
    public TimeParamConvertor timeParamConvertor() {
        return new TimeParamConvertor();
    }

    @Bean
    @ConditionalOnMissingBean(value={DateTimeParamConvertor.class})
    public DateTimeParamConvertor dateTimeParamConvertor() {
        return new DateTimeParamConvertor();
    }

    @Bean
    @ConditionalOnMissingBean(value={SizeLimitParamFilter.class})
    public SizeLimitParamFilter sizeLimitParamFilter(BeanSearcherProperties config) {
        return new SizeLimitParamFilter(config.getParams().getFilter().getMaxParaMapSize());
    }

    @Bean
    @ConditionalOnMissingBean(value={ParamResolver.class})
    public ParamResolver paramResolver(PageExtractor pageExtractor, FieldOpPool fieldOpPool, List<ParamFilter> paramFilters, List<FieldConvertor.ParamConvertor> convertors, GroupResolver groupResolver, BeanSearcherProperties config) {
        DefaultParamResolver paramResolver = new DefaultParamResolver(convertors, paramFilters);
        paramResolver.setPageExtractor(pageExtractor);
        paramResolver.setFieldOpPool(fieldOpPool);
        BeanSearcherProperties.Params conf = config.getParams();
        paramResolver.setOperatorSuffix(conf.getOperatorKey());
        paramResolver.setIgnoreCaseSuffix(conf.getIgnoreCaseKey());
        paramResolver.setOrderName(conf.getOrder());
        paramResolver.setSortName(conf.getSort());
        paramResolver.setOrderByName(conf.getOrderBy());
        paramResolver.setSeparator(conf.getSeparator());
        paramResolver.setOnlySelectName(conf.getOnlySelect());
        paramResolver.setSelectExcludeName(conf.getSelectExclude());
        BeanSearcherProperties.Params.Group group = conf.getGroup();
        paramResolver.setGexprName(group.getExprName());
        paramResolver.setGroupSeparator(group.getSeparator());
        paramResolver.setGroupResolver(groupResolver);
        return paramResolver;
    }

    @Bean
    @ConditionalOnMissingBean(value={GroupPair.Resolver.class})
    public GroupPair.Resolver groupPairResolver() {
        return new GroupPairResolver();
    }

    @Bean
    @ConditionalOnMissingBean(value={SqlResolver.class})
    public SqlResolver sqlResolver(Dialect dialect, GroupPair.Resolver groupPairResolver) {
        DefaultSqlResolver resolver = new DefaultSqlResolver(dialect);
        resolver.setGroupPairResolver(groupPairResolver);
        return resolver;
    }

    @Bean
    @ConditionalOnMissingBean(value={SqlExecutor.class})
    public SqlExecutor sqlExecutor(ObjectProvider<DataSource> dataSource, ObjectProvider<List<NamedDataSource>> namedDataSources, ObjectProvider<SqlExecutor.SlowListener> slowListener, BeanSearcherProperties config) {
        DefaultSqlExecutor executor = new DefaultSqlExecutor((DataSource)dataSource.getIfAvailable());
        this.ifAvailable(namedDataSources, ndsList -> {
            for (NamedDataSource nds : ndsList) {
                executor.setDataSource(nds.getName(), nds.getDataSource());
            }
        });
        this.ifAvailable(slowListener, arg_0 -> ((DefaultSqlExecutor)executor).setSlowListener(arg_0));
        executor.setSlowSqlThreshold(config.getSql().getSlowSqlThreshold());
        return executor;
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-number"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={NumberFieldConvertor.class})
    public NumberFieldConvertor numberFieldConvertor() {
        return new NumberFieldConvertor();
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-str-num"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={StrNumFieldConvertor.class})
    public StrNumFieldConvertor strNumFieldConvertor() {
        return new StrNumFieldConvertor();
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-bool-num"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={BoolNumFieldConvertor.class})
    public BoolNumFieldConvertor boolNumFieldConvertor() {
        return new BoolNumFieldConvertor();
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-bool"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={BoolFieldConvertor.class})
    public BoolFieldConvertor boolFieldConvertor(BeanSearcherProperties config) {
        String[] falseValues = config.getFieldConvertor().getBoolFalseValues();
        BoolFieldConvertor convertor = new BoolFieldConvertor();
        if (falseValues != null) {
            convertor.addFalseValues(falseValues);
        }
        return convertor;
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-date"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={DateFieldConvertor.class})
    public DateFieldConvertor dateFieldConvertor(BeanSearcherProperties config) {
        DateFieldConvertor convertor = new DateFieldConvertor();
        ZoneId zoneId = config.getFieldConvertor().getZoneId();
        if (zoneId != null) {
            convertor.setZoneId(zoneId);
        }
        return convertor;
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-time"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={TimeFieldConvertor.class})
    public TimeFieldConvertor timeFieldConvertor() {
        return new TimeFieldConvertor();
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-enum"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={EnumFieldConvertor.class})
    public EnumFieldConvertor enumFieldConvertor(BeanSearcherProperties config) {
        BeanSearcherProperties.FieldConvertor conf = config.getFieldConvertor();
        EnumFieldConvertor convertor = new EnumFieldConvertor();
        convertor.setFailOnError(conf.isEnumFailOnError());
        convertor.setIgnoreCase(conf.isEnumIgnoreCase());
        return convertor;
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-list"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={ListFieldConvertor.class})
    public ListFieldConvertor listFieldConvertor(BeanSearcherProperties config, ObjectProvider<List<ListFieldConvertor.Convertor<?>>> convertorsProvider) {
        BeanSearcherProperties.FieldConvertor conf = config.getFieldConvertor();
        ListFieldConvertor convertor = new ListFieldConvertor(conf.getListItemSeparator());
        this.ifAvailable(convertorsProvider, arg_0 -> ((ListFieldConvertor)convertor).setConvertors(arg_0));
        return convertor;
    }

    @Bean
    @ConditionalOnMissingBean(value={BeanReflector.class})
    public BeanReflector beanReflector(ObjectProvider<List<FieldConvertor.BFieldConvertor>> convertorsProvider) {
        List convertors = (List)convertorsProvider.getIfAvailable();
        if (convertors != null) {
            return new DefaultBeanReflector(convertors);
        }
        return new DefaultBeanReflector();
    }

    @Bean
    @ConditionalOnMissingBean(value={DbMapping.class})
    public DbMapping dbMapping(BeanSearcherProperties config) {
        DefaultDbMapping mapping = new DefaultDbMapping();
        BeanSearcherProperties.Sql.DefaultMapping conf = config.getSql().getDefaultMapping();
        mapping.setTablePrefix(conf.getTablePrefix());
        mapping.setUpperCase(conf.isUpperCase());
        mapping.setUnderlineCase(conf.isUnderlineCase());
        mapping.setRedundantSuffixes(conf.getRedundantSuffixes());
        mapping.setIgnoreFields(conf.getIgnoreFields());
        mapping.setDefaultInheritType(conf.getInheritType());
        mapping.setDefaultSortType(conf.getSortType());
        mapping.setAroundChar(conf.getAroundChar());
        return mapping;
    }

    @Bean
    @ConditionalOnMissingBean(value={MetaResolver.class})
    public MetaResolver metaResolver(DbMapping dbMapping, ObjectProvider<SnippetResolver> snippetResolver) {
        DefaultMetaResolver metaResolver = new DefaultMetaResolver(dbMapping);
        this.ifAvailable(snippetResolver, arg_0 -> ((DefaultMetaResolver)metaResolver).setSnippetResolver(arg_0));
        return metaResolver;
    }

    @Bean
    @ConditionalOnMissingBean(value={BeanSearcher.class})
    @ConditionalOnProperty(name={"bean-searcher.use-bean-searcher"}, havingValue="true", matchIfMissing=true)
    public BeanSearcher beanSearcher(MetaResolver metaResolver, ParamResolver paramResolver, SqlResolver sqlResolver, SqlExecutor sqlExecutor, BeanReflector beanReflector, ObjectProvider<List<SqlInterceptor>> interceptors, ObjectProvider<List<ResultFilter>> processors) {
        DefaultBeanSearcher searcher = new DefaultBeanSearcher();
        searcher.setMetaResolver(metaResolver);
        searcher.setParamResolver(paramResolver);
        searcher.setSqlResolver(sqlResolver);
        searcher.setSqlExecutor(sqlExecutor);
        searcher.setBeanReflector(beanReflector);
        this.ifAvailable(interceptors, arg_0 -> ((DefaultBeanSearcher)searcher).setInterceptors(arg_0));
        this.ifAvailable(processors, arg_0 -> ((DefaultBeanSearcher)searcher).setResultFilters(arg_0));
        return searcher;
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-date-format"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={DateFormatFieldConvertor.class})
    public DateFormatFieldConvertor dateFormatFieldConvertor(BeanSearcherProperties config) {
        BeanSearcherProperties.FieldConvertor conf = config.getFieldConvertor();
        Map<String, String> dateFormats = conf.getDateFormats();
        ZoneId zoneId = conf.getZoneId();
        DateFormatFieldConvertor convertor = new DateFormatFieldConvertor();
        if (dateFormats != null) {
            dateFormats.forEach((key, value) -> {
                String scope = key.replace('-', ':');
                convertor.setFormat(scope, value);
            });
        }
        if (zoneId != null) {
            convertor.setZoneId(zoneId);
        }
        return convertor;
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-b2-m"}, havingValue="true")
    @ConditionalOnMissingBean(value={B2MFieldConvertor.class})
    public B2MFieldConvertor b2mFieldConvertor(ObjectProvider<List<FieldConvertor.BFieldConvertor>> convertors) {
        List list = (List)convertors.getIfAvailable();
        if (list != null) {
            return new B2MFieldConvertor(list);
        }
        return new B2MFieldConvertor(Collections.emptyList());
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean(value={MapSearcher.class})
    @ConditionalOnProperty(name={"bean-searcher.use-map-searcher"}, havingValue="true", matchIfMissing=true)
    public MapSearcher mapSearcher(MetaResolver metaResolver, ParamResolver paramResolver, SqlResolver sqlResolver, SqlExecutor sqlExecutor, ObjectProvider<List<FieldConvertor.MFieldConvertor>> convertors, ObjectProvider<List<SqlInterceptor>> interceptors, ObjectProvider<List<ResultFilter>> resultFilters) {
        DefaultMapSearcher searcher = new DefaultMapSearcher();
        searcher.setMetaResolver(metaResolver);
        searcher.setParamResolver(paramResolver);
        searcher.setSqlResolver(sqlResolver);
        searcher.setSqlExecutor(sqlExecutor);
        List list = (List)convertors.getIfAvailable();
        if (list != null) {
            ArrayList newList = new ArrayList(list);
            newList.sort((o1, o2) -> {
                if (o1 instanceof DateFormatFieldConvertor) {
                    return -1;
                }
                if (o2 instanceof DateFormatFieldConvertor) {
                    return 1;
                }
                return 0;
            });
            searcher.setConvertors(newList);
        }
        this.ifAvailable(interceptors, arg_0 -> ((DefaultMapSearcher)searcher).setInterceptors(arg_0));
        this.ifAvailable(resultFilters, arg_0 -> ((DefaultMapSearcher)searcher).setResultFilters(arg_0));
        return searcher;
    }

    private <T> void ifAvailable(ObjectProvider<T> provider, Consumer<T> consumer) {
        Object dependency = provider.getIfAvailable();
        if (dependency != null) {
            consumer.accept(dependency);
        }
    }

    @Configuration
    @ConditionalOnClass(value={JsonKit.class})
    @ConditionalOnProperty(name={"bean-searcher.field-convertor.use-json"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={JsonFieldConvertor.class})
    public static class JsonFieldConvertorConfig {
        @Bean
        public JsonFieldConvertor jsonFieldConvertor(BeanSearcherProperties config) {
            BeanSearcherProperties.FieldConvertor conf = config.getFieldConvertor();
            return new JsonFieldConvertor(conf.isJsonFailOnError());
        }
    }
}

