/*
 * Decompiled with CFR 0.152.
 */
package cn.zhgliu.reptile.area.util;

import cn.hutool.core.lang.Assert;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.zhgliu.reptile.area.consts.AreaLevel;
import cn.zhgliu.reptile.area.model.AreaNode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaReptileUtil {
    private static final Logger logger = LoggerFactory.getLogger(AreaReptileUtil.class);
    private static final String BASE_URL = "http://www.stats.gov.cn/tjsj/tjbz/tjyqhdmhcxhfdm/";
    public static Boolean DEBUG_MODE = false;
    private static final Pattern PROVINCE_PATTERN = Pattern.compile("(^\\d{2})\\.html");

    public static Boolean getDebugMode() {
        return DEBUG_MODE;
    }

    public static void setDebugMode(Boolean debugMode) {
        DEBUG_MODE = debugMode;
    }

    public static List<AreaNode> doCrawlJson(String year, AreaLevel targetLevel) {
        AtomicInteger count = new AtomicInteger(0);
        List<AreaNode> provinceList = AreaReptileUtil.getProvince(year);
        logger.debug("\u83b7\u53d6\u7701\u4efd{}\u4e2a", (Object)provinceList.size());
        for (AreaNode province : provinceList) {
            int c = count.addAndGet(3);
            if (DEBUG_MODE.booleanValue() && c > 1) break;
            AreaReptileUtil.getNodeList(province, targetLevel);
        }
        return provinceList;
    }

    public static List<AreaNode> doCrawlFlat(String year, AreaLevel targetLevel) {
        List<AreaNode> provinceList = AreaReptileUtil.doCrawlJson(year, targetLevel);
        List<AreaNode> flatten = AreaReptileUtil.flatten(provinceList);
        return flatten;
    }

    private static List<AreaNode> getChildren(AreaNode node) {
        LinkedList<AreaNode> ret = new LinkedList<AreaNode>();
        String parentCode = node.getCode();
        List<AreaNode> children = node.getChildren();
        if (children == null) {
            return ret;
        }
        children.stream().forEach(item -> {
            ret.add(item.setpCode(parentCode));
            ret.addAll(AreaReptileUtil.getChildren(item));
            item.setChildren(null);
        });
        return ret;
    }

    private static List<AreaNode> flatten(List<AreaNode> resource) {
        LinkedList<AreaNode> ret = new LinkedList<AreaNode>();
        resource.stream().forEach(node -> {
            ret.add((AreaNode)node);
            ret.addAll(AreaReptileUtil.getChildren(node));
            node.setChildren(null);
        });
        return ret;
    }

    private static String getHtmlUrl(String baseUrl, String param) {
        return new StringBuffer(baseUrl).append(param).append("/").toString();
    }

    private static Element getHtmlBodyElement(String url) {
        return AreaReptileUtil.getHtmlBodyElement(url, 0);
    }

    private static Element getHtmlBodyElement(String url, Integer failCount) {
        String html;
        try {
            HttpResponse response = HttpRequest.get((String)url).timeout(5000).execute();
            if (response.getStatus() != 200) {
                System.out.println(response);
                throw new RuntimeException("http\u8fd4\u56de\u503c\u662f" + response.getStatus());
            }
            html = response.body();
        }
        catch (Exception e) {
            if (failCount < 3) {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                return AreaReptileUtil.getHtmlBodyElement(url, failCount + 1);
            }
            throw e;
        }
        Assert.notNull((Object)html, (String)html, (Object[])new Object[0]);
        Document parse = Jsoup.parse((String)html);
        return parse.body();
    }

    private static List<AreaNode> getProvince(String year) {
        String htmlUrl = AreaReptileUtil.getHtmlUrl(BASE_URL, year);
        logger.debug(htmlUrl);
        Element htmlBodyElement = AreaReptileUtil.getHtmlBodyElement(htmlUrl);
        ArrayList<AreaNode> provinceList = new ArrayList<AreaNode>(34);
        Elements aTags = htmlBodyElement.getElementsByTag("a");
        aTags.forEach(a -> {
            String provinceName = a.ownText();
            String provinceUrl = a.attr("href");
            Matcher provinceMatcher = PROVINCE_PATTERN.matcher(provinceUrl);
            if (provinceMatcher.matches()) {
                String areaCode = provinceMatcher.group(1);
                AreaNode node = new AreaNode(areaCode, provinceName, AreaLevel.PROVINCE);
                String detailUrl = htmlUrl + areaCode + ".html";
                node.setCurrentDetailUrl(detailUrl);
                provinceList.add(node);
            }
        });
        return provinceList;
    }

    private static void getNodeList(AreaNode areaNode, AreaLevel targetAreaLevel) {
        if (!targetAreaLevel.equals((Object)areaNode.getLevel())) {
            areaNode.setChildren(new LinkedList<AreaNode>());
            String currentDetailUrl = areaNode.getCurrentDetailUrl();
            logger.debug("CURRENT_DETAIL_URL IS: {}", (Object)currentDetailUrl);
            Element htmlBodyElement = AreaReptileUtil.getHtmlBodyElement(currentDetailUrl);
            Elements trTags = htmlBodyElement.getElementsByClass(areaNode.getLevel().nextLevel().getLevelName() + "tr");
            trTags.stream().forEach(trElement -> {
                AreaNode child;
                Elements tds = trElement.getElementsByTag("td");
                if (tds.size() == 2) {
                    child = new AreaNode(((Element)tds.get(0)).text(), ((Element)tds.get(1)).text(), areaNode.getLevel().nextLevel());
                } else if (tds.size() == 3) {
                    child = new AreaNode(((Element)tds.get(0)).text(), ((Element)tds.get(2)).text(), areaNode.getLevel().nextLevel());
                    child.setVillageCategoryCode(((Element)tds.get(1)).text());
                } else {
                    throw new RuntimeException("\u7edf\u8ba1\u5c40\u9875\u9762\u6570\u636e\u683c\u5f0f\u53d1\u751f\u53d8\u5316");
                }
                areaNode.getChildren().add(child);
                Elements a = trElement.getElementsByTag("a");
                if (a.size() == 0) {
                    return;
                }
                String href = ((Element)a.get(0)).attr("href");
                String detailUrl = currentDetailUrl.substring(0, currentDetailUrl.lastIndexOf("/")) + "/" + href;
                child.setCurrentDetailUrl(detailUrl);
                AreaReptileUtil.getNodeList(child, targetAreaLevel);
            });
        }
    }
}

