/*
 * Decompiled with CFR 0.152.
 */
package cn.zhgliu.reptile.area.consts;

public enum AreaLevel {
    PROVINCE(1, "province"),
    CITY(2, "city"),
    COUNTY(3, "county"),
    TOWN(4, "town"),
    VILLAGE(5, "village");

    private Integer levelCode;
    private String levelName;

    private AreaLevel(Integer levelCode, String levelName) {
        this.levelCode = levelCode;
        this.levelName = levelName;
    }

    public Integer getLevelCode() {
        return this.levelCode;
    }

    public static AreaLevel nextLevel(AreaLevel areaLevel) {
        switch (areaLevel) {
            case PROVINCE: {
                return CITY;
            }
            case CITY: {
                return COUNTY;
            }
            case COUNTY: {
                return TOWN;
            }
            case TOWN: {
                return VILLAGE;
            }
        }
        throw new RuntimeException("Can not get next level of LV5");
    }

    public AreaLevel nextLevel() {
        switch (this) {
            case PROVINCE: {
                return CITY;
            }
            case CITY: {
                return COUNTY;
            }
            case COUNTY: {
                return TOWN;
            }
            case TOWN: {
                return VILLAGE;
            }
        }
        throw new RuntimeException("Can not get next level of LV5");
    }

    public String getLevelName() {
        return this.levelName;
    }

    public static void main(String[] args) {
        System.out.println(PROVINCE.getLevelCode());
    }
}

