package cn.ztc.tool.redis.template.serializer;

import java.nio.charset.StandardCharsets;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;

import org.springframework.data.redis.serializer.RedisSerializer;

/**
 * Value序列化器
 * <p>基础类型参考最小存储方案<br>其他类型使用JSON字符串</p>
 *
 * @author 张天赐
 */
public class ValueSerializer<T> implements RedisSerializer<T> {
    @Override
    public byte[] serialize(Object o) {
        if (o == null) {return new byte[0];}
        // 序列化
        else {return JSON.toJSONString(o).getBytes(StandardCharsets.UTF_8);}
    }

    @Override
    public T deserialize(byte[] bytes) {
        // redis 未存储
        if (bytes == null) {return null;}
        // redis 存储为null
        else if (bytes.length == 0) {return null;}
        // 反序列化
        else {
            return JSON.parseObject(new String(bytes, StandardCharsets.UTF_8), new TypeReference<T>() {});
        }
    }
}

