package cn.ztc.tool.redis.template.serializer;

import java.nio.charset.StandardCharsets;

import org.springframework.data.redis.serializer.RedisSerializer;

/**
 * Key序列化
 * <p>总是序列化为字符串</p>
 *
 * @author 张天赐
 */
public class KeySerializer<T> implements RedisSerializer<T> {
    @Override
    public byte[] serialize(Object o) {
        if (o == null) {return new byte[0];}
        return o.toString().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public T deserialize(byte[] bytes) {
        throw new RuntimeException("redis key 不需要反序列化");
    }
}

