/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangsw.generator.util;

import cn.hutool.core.date.DateTime;
import cn.zhangsw.generator.config.AutoCodeConfig;
import cn.zhangsw.generator.config.GlobalConfig;
import cn.zhangsw.generator.model.BeanColumn;
import cn.zhangsw.generator.model.TsysTables;
import cn.zhangsw.generator.util.SnowflakeIdWorker;
import cn.zhangsw.generator.util.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class AutoCodeUtil {
    private static String targetPath = AutoCodeUtil.getTargetPath();

    private AutoCodeUtil() {
    }

    public static String getTargetPath() {
        return AutoCodeConfig.getGlobalConfig().getParentPath();
    }

    public static List<String> getTemplates() {
        ArrayList<String> templates = new ArrayList<String>();
        templates.add("auto_code/model/Entity.java.vm");
        templates.add("auto_code/model/EntityExample.java.vm");
        templates.add("auto_code/mapperxml/EntityMapper.xml.vm");
        templates.add("auto_code/service/EntityService.java.vm");
        templates.add("auto_code/dao/EntityMapper.java.vm");
        templates.add("auto_code/controller/EntityController.java.vm");
        return templates;
    }

    public static void autoCodeOneModel(TsysTables tables, List<BeanColumn> beanColumns, String conditionQueryField, Boolean vController, Boolean vService, Boolean vMapperORdao) {
        Properties prop = new Properties();
        prop.put("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.init((Properties)prop);
        GlobalConfig globalConfig = AutoCodeConfig.getGlobalConfig();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TsysTables", tables);
        map.put("beanColumns", beanColumns);
        map.put("globalConfig", globalConfig);
        map.put("datetime", new DateTime());
        map.put("conditionQueryField", conditionQueryField);
        map.put("conditionQueryField_a", StringUtils.firstLowerCase(conditionQueryField));
        map.put("SnowflakeIdWorker", SnowflakeIdWorker.class);
        map.put("JavaClassPackages", AutoCodeUtil.getJavaClassPackage(beanColumns));
        VelocityContext context = new VelocityContext(map);
        List<String> templates = AutoCodeUtil.getTemplates();
        if (!vController.booleanValue()) {
            templates.remove("auto_code/controller/EntityController.java.vm");
        }
        if (!vService.booleanValue()) {
            templates.remove("auto_code/service/EntityService.java.vm");
        }
        if (!vMapperORdao.booleanValue()) {
            templates.remove("auto_code/model/Entity.java.vm");
            templates.remove("auto_code/model/EntityExample.java.vm");
            templates.remove("auto_code/mapperxml/EntityMapper.xml.vm");
            templates.remove("auto_code/dao/EntityMapper.java.vm");
        }
        for (String template : templates) {
            try {
                String filepath = AutoCodeUtil.getCoverFileName(template, tables.getTableModel_a(), tables.getTableModel(), globalConfig.getParentPack());
                Template tpl = Velocity.getTemplate((String)template, (String)"UTF-8");
                File file = new File(filepath);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (!file.exists()) {
                    file.createNewFile();
                }
                FileOutputStream outStream = new FileOutputStream(file);
                Throwable throwable = null;
                try {
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outStream, "UTF-8");
                    Throwable throwable2 = null;
                    try {
                        BufferedWriter sw = new BufferedWriter(writer);
                        Throwable throwable3 = null;
                        try {
                            tpl.merge((Context)context, (Writer)sw);
                            sw.flush();
                            System.out.println("\u6210\u529f\u751f\u6210Java\u6587\u4ef6:" + filepath);
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (sw == null) continue;
                            if (throwable3 != null) {
                                try {
                                    sw.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            sw.close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (writer == null) continue;
                        if (throwable2 != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        writer.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (outStream == null) continue;
                    if (throwable != null) {
                        try {
                            outStream.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    outStream.close();
                }
            }
            catch (IOException e) {
                try {
                    throw new Exception("\u6e32\u67d3\u6a21\u677f\u5931\u8d25\uff0c\u8868\u540d\uff1a" + tables.getTableName() + "\n" + e.getMessage());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static String getCoverFileName(String template, String classname, String className, String packageName) {
        String packagePath = targetPath + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator;
        String resourcesPath = targetPath + File.separator + "src" + File.separator + "main" + File.separator + "resources" + File.separator;
        GlobalConfig globalConfig = AutoCodeConfig.getGlobalConfig();
        if (StringUtils.isNotBlank((CharSequence)packageName)) {
            packagePath = packagePath + packageName.replace(".", File.separator) + File.separator;
        }
        if (template.contains("Entity.java.vm")) {
            String beanPackageName = globalConfig.getBeanPackageName();
            String beanNameSuffix = globalConfig.getBeanNameSuffix();
            return packagePath + beanPackageName + File.separator + className + beanNameSuffix + ".java";
        }
        if (template.contains("EntityExample.java.vm")) {
            String beanPackageName = globalConfig.getBeanPackageName();
            String beanNameSuffix = globalConfig.getBeanNameSuffix();
            return packagePath + beanPackageName + File.separator + className + beanNameSuffix + "Example.java";
        }
        if (template.contains("EntityMapper.java.vm")) {
            String daoNameSuffix = globalConfig.getDaoNameSuffix();
            String daoPackageName = globalConfig.getDaoPackageName();
            return packagePath + daoPackageName + File.separator + className + daoNameSuffix + ".java";
        }
        if (template.contains("EntityMapper.xml.vm")) {
            String daoNameSuffix = globalConfig.getDaoNameSuffix();
            return resourcesPath + globalConfig.getXmlPath() + File.separator + className + daoNameSuffix + ".xml";
        }
        if (template.contains("EntityService.java.vm")) {
            String serviceNameSuffix = globalConfig.getServiceNameSuffix();
            String servicePackageName = globalConfig.getServicePackageName();
            return packagePath + servicePackageName + File.separator + className + serviceNameSuffix + ".java";
        }
        if (template.contains("EntityController.java.vm")) {
            String controllerNameSuffix = globalConfig.getControllerNameSuffix();
            String controllerPackageName = globalConfig.getControllerPackageName();
            return packagePath + controllerPackageName + File.separator + className + controllerNameSuffix + ".java";
        }
        return null;
    }

    public static String getJavaClassPackage(List<BeanColumn> beanColumns) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer buffer = new StringBuffer();
        for (BeanColumn beanColumn : beanColumns) {
            map.put(beanColumn.getBeanType(), beanColumn.getBeanType());
        }
        if (map.size() > 0) {
            boolean time = false;
            for (String key : map.keySet()) {
                if (!"java.lang.String".equals(key)) {
                    buffer.append("import " + (String)map.get(key) + ";\n");
                }
                if (!"java.util.Date".equals(key) || time) continue;
                time = true;
                buffer.append("import com.fasterxml.jackson.annotation.JsonFormat;\n");
            }
        }
        return buffer.toString();
    }
}

