/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangsw.generator;

import cn.hutool.core.util.StrUtil;
import cn.zhangsw.generator.ApplicationStartedListener;
import cn.zhangsw.generator.config.GeneratorConfig;
import cn.zhangsw.generator.util.StringUtils;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;

@SpringBootApplication(scanBasePackages={"cn.zhangsw"})
@MapperScan(basePackages={"cn.zhangsw.generator.dao"})
public class Mysql2MybatisUITool {
    public static GeneratorConfig generatorConfig;

    public static void run(GeneratorConfig generatorConfig) {
        String tableName = StringUtils.findDataBaseNameByUrl(generatorConfig.getUrl());
        String schemaName = generatorConfig.getSchemaName();
        if (StringUtils.isEmpty(tableName)) {
            if (StringUtils.isEmpty(schemaName)) {
                throw new IllegalArgumentException("jdbcurl\u683c\u5f0f\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u6570\u636e\u5e93");
            }
            generatorConfig.setUrl(generatorConfig.getUrl() + "/" + schemaName);
        } else if (StringUtils.isEmpty(schemaName)) {
            generatorConfig.setSchemaName(tableName);
        }
        Mysql2MybatisUITool.generatorConfig = generatorConfig;
        SpringApplicationBuilder sources = new SpringApplicationBuilder(new Class[0]).sources(new Class[]{Mysql2MybatisUITool.class});
        sources.application().addListeners(new ApplicationListener[]{new ApplicationStartedListener()});
        sources.run(new String[0]);
    }

    @Bean
    public GeneratorConfig getDataSource() {
        return generatorConfig;
    }

    @Bean
    public WebServerFactoryCustomizer<ConfigurableServletWebServerFactory> containerConfig(GeneratorConfig generatorConfig) {
        return factory -> {
            if (generatorConfig.getPort() == 0) {
                factory.setPort(8080);
            } else {
                factory.setPort(generatorConfig.getPort());
            }
            factory.setContextPath("");
        };
    }

    @Bean
    public DataSource dataSource(GeneratorConfig config) {
        if (StrUtil.isBlank((CharSequence)config.getUrl())) {
            throw new IllegalArgumentException("\u5fc5\u987b\u6307\u5b9ajdbcUrl\u7528\u4e8e\u521b\u5efa\u6570\u636e\u6e90");
        }
        HikariDataSource ds = new HikariDataSource();
        ds.setJdbcUrl(config.getUrl());
        ds.setUsername(config.getUsername());
        ds.setPassword(config.getPassword());
        ds.setDriverClassName(config.getDriverClassName());
        return ds;
    }
}

