/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangqin56.common.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import java.lang.reflect.Field;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectFieldsEqualUtils {
    private static final Logger logger = LoggerFactory.getLogger(ObjectFieldsEqualUtils.class);

    public static <T> boolean isSameDataExceptSomeFields(T obj1, T obj2, List<String> exceptFieldNames) {
        logger.info("\n");
        logger.debug("exceptField:{}", exceptFieldNames);
        List<Object> fields = CollUtil.toList((Object[])ReflectUtil.getFields(obj1.getClass()));
        if (CollUtil.isNotEmpty(exceptFieldNames)) {
            fields = fields.stream().filter(i -> !exceptFieldNames.contains(i.getName())).toList();
        }
        logger.debug("CheckFields:{}", fields.stream().map(Field::getName).toList());
        boolean res = true;
        for (Field field : fields) {
            Object value2;
            Object value1 = ReflectUtil.getFieldValue(obj1, (Field)field);
            if (ObjectUtil.equal((Object)value1, (Object)(value2 = ReflectUtil.getFieldValue(obj2, (Field)field)))) {
                logger.debug("\u5b57\u6bb5\u76f8\u540c\u3002\u5b57\u6bb5\uff1a{}\uff0c\u503c\uff1a{}", (Object)field.getName(), value1);
                continue;
            }
            logger.info("\u5b57\u6bb5\u503c\u4e0d\u540c\u3002\u5b57\u6bb5\uff1a{}\uff0c\u503c\uff1a{}/{}", new Object[]{field.getName(), value1, value2});
            res = false;
        }
        return res;
    }

    public static <T> boolean isSameDataExceptSomeFields(List<T> objs, List<String> exceptFieldNames) {
        if (CollUtil.isEmpty(objs) || objs.size() < 2) {
            return false;
        }
        T obj1 = objs.get(0);
        boolean ret = true;
        for (int i = 1; i < objs.size(); ++i) {
            ret = ret && ObjectFieldsEqualUtils.isSameDataExceptSomeFields(obj1, objs.get(i), exceptFieldNames);
        }
        return ret;
    }

    public static <T> boolean isSameData(T obj1, T obj2) {
        return ObjectFieldsEqualUtils.isSameDataExceptSomeFields(obj1, obj2, null);
    }

    public static <T> boolean isSameData(List<T> objs) {
        return ObjectFieldsEqualUtils.isSameDataExceptSomeFields(objs, null);
    }

    public static <T> boolean isSameData(T ... objs) {
        return ObjectFieldsEqualUtils.isSameDataExceptSomeFields(CollUtil.toList((Object[])objs), null);
    }

    private ObjectFieldsEqualUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

