/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangqin56.common.utils;

import cn.hutool.core.collection.CollUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public final class BigDecimalUtils {
    public static final int DEFAULT_DIVIDE_SCALE = 5;
    public static final int DEFAULT_MULTIPLY_SCALE = 2;

    public static BigDecimal sum(BigDecimal ... numbers) {
        return BigDecimalUtils.sum(Arrays.asList(numbers));
    }

    public static BigDecimal sum(List<BigDecimal> numbers) {
        if (CollUtil.isEmpty(numbers)) {
            return BigDecimal.ZERO;
        }
        return numbers.stream().filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static <T> BigDecimal sum(List<T> objsContainsBigDecimal, Function<T, BigDecimal> ref) {
        return objsContainsBigDecimal.stream().filter(Objects::nonNull).map(ref).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static <T> BigDecimal sum(List<T> objsContainsBigDecimal, Predicate<T> filter, Function<T, BigDecimal> ref) {
        if (CollUtil.isEmpty(objsContainsBigDecimal)) {
            return BigDecimal.ZERO;
        }
        return objsContainsBigDecimal.stream().filter(Objects::nonNull).filter(filter).map(ref).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static boolean gt(BigDecimal v1, BigDecimal v2) {
        return v1.compareTo(v2) > 0;
    }

    public static boolean gt0(BigDecimal v) {
        return BigDecimalUtils.gt(v, BigDecimal.ZERO);
    }

    public static boolean ge(BigDecimal v1, BigDecimal v2) {
        return v1.compareTo(v2) >= 0;
    }

    public static boolean ge0(BigDecimal v) {
        return BigDecimalUtils.ge(v, BigDecimal.ZERO);
    }

    public static boolean lt(BigDecimal v1, BigDecimal v2) {
        return v1.compareTo(v2) < 0;
    }

    public static boolean lt0(BigDecimal v) {
        return BigDecimalUtils.lt(v, BigDecimal.ZERO);
    }

    public static boolean le(BigDecimal v1, BigDecimal v2) {
        return v1.compareTo(v2) <= 0;
    }

    public static boolean le0(BigDecimal v) {
        return BigDecimalUtils.le(v, BigDecimal.ZERO);
    }

    public static boolean ne(BigDecimal v1, BigDecimal v2) {
        return v1.compareTo(v2) != 0;
    }

    public static boolean ne0(BigDecimal v) {
        return BigDecimalUtils.ne(v, BigDecimal.ZERO);
    }

    public static boolean eq(BigDecimal v1, BigDecimal v2) {
        return v1.compareTo(v2) == 0;
    }

    public static boolean eq0(BigDecimal v) {
        return BigDecimalUtils.eq(v, BigDecimal.ZERO);
    }

    public static BigDecimal wrapBigDecimal(BigDecimal value) {
        return Optional.ofNullable(value).orElse(BigDecimal.ZERO);
    }

    public static BigDecimal negate(BigDecimal value) {
        return BigDecimalUtils.wrapBigDecimal(value).abs().negate();
    }

    public static BigDecimal cal(BigDecimal v1, BigDecimal v2, CalculateType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case CalculateType.ADD -> BigDecimalUtils.wrapBigDecimal(v1).add(BigDecimalUtils.wrapBigDecimal(v2));
            case CalculateType.SUBTRACT -> BigDecimalUtils.wrapBigDecimal(v1).subtract(BigDecimalUtils.wrapBigDecimal(v2));
            case CalculateType.MULTIPLY, CalculateType.MULTIPLY_CEILING -> BigDecimalUtils.wrapBigDecimal(v1).multiply(BigDecimalUtils.wrapBigDecimal(v2)).setScale(5, RoundingMode.CEILING);
            case CalculateType.MULTIPLY_UP -> BigDecimalUtils.wrapBigDecimal(v1).multiply(BigDecimalUtils.wrapBigDecimal(v2)).setScale(2, RoundingMode.UP);
            case CalculateType.MULTIPLY_DOWN -> BigDecimalUtils.wrapBigDecimal(v1).multiply(BigDecimalUtils.wrapBigDecimal(v2)).setScale(2, RoundingMode.DOWN);
            case CalculateType.MULTIPLY_FLOOR -> BigDecimalUtils.wrapBigDecimal(v1).multiply(BigDecimalUtils.wrapBigDecimal(v2)).setScale(2, RoundingMode.FLOOR);
            case CalculateType.MULTIPLY_HALF_UP -> BigDecimalUtils.wrapBigDecimal(v1).multiply(BigDecimalUtils.wrapBigDecimal(v2)).setScale(2, RoundingMode.HALF_UP);
            case CalculateType.MULTIPLY_HALF_DOWN -> BigDecimalUtils.wrapBigDecimal(v1).multiply(BigDecimalUtils.wrapBigDecimal(v2)).setScale(2, RoundingMode.HALF_DOWN);
            case CalculateType.MULTIPLY_HALF_EVEN -> BigDecimalUtils.wrapBigDecimal(v1).multiply(BigDecimalUtils.wrapBigDecimal(v2)).setScale(2, RoundingMode.HALF_EVEN);
            case CalculateType.MULTIPLY_UNNECESSARY -> BigDecimalUtils.wrapBigDecimal(v1).multiply(BigDecimalUtils.wrapBigDecimal(v2)).setScale(2, RoundingMode.UNNECESSARY);
            case CalculateType.DIVIDE_UP -> BigDecimalUtils.wrapBigDecimal(v1).divide(v2, 5, RoundingMode.UP);
            case CalculateType.DIVIDE_DOWN -> BigDecimalUtils.wrapBigDecimal(v1).divide(v2, 5, RoundingMode.DOWN);
            case CalculateType.DIVIDE_CEILING -> BigDecimalUtils.wrapBigDecimal(v1).divide(v2, 5, RoundingMode.CEILING);
            case CalculateType.DIVIDE_FLOOR -> BigDecimalUtils.wrapBigDecimal(v1).divide(v2, 5, RoundingMode.FLOOR);
            case CalculateType.DIVIDE_HALF_UP -> BigDecimalUtils.wrapBigDecimal(v1).divide(v2, 5, RoundingMode.HALF_UP);
            case CalculateType.DIVIDE_HALF_DOWN -> BigDecimalUtils.wrapBigDecimal(v1).divide(v2, 5, RoundingMode.HALF_DOWN);
            case CalculateType.DIVIDE_HALF_EVEN -> BigDecimalUtils.wrapBigDecimal(v1).divide(v2, 5, RoundingMode.HALF_EVEN);
            case CalculateType.DIVIDE_UNNECESSARY -> BigDecimalUtils.wrapBigDecimal(v1).divide(v2, 5, RoundingMode.UNNECESSARY);
        };
    }

    private BigDecimalUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum CalculateType {
        ADD,
        SUBTRACT,
        MULTIPLY,
        MULTIPLY_UP,
        MULTIPLY_DOWN,
        MULTIPLY_CEILING,
        MULTIPLY_FLOOR,
        MULTIPLY_HALF_UP,
        MULTIPLY_HALF_DOWN,
        MULTIPLY_HALF_EVEN,
        MULTIPLY_UNNECESSARY,
        DIVIDE_UP,
        DIVIDE_DOWN,
        DIVIDE_CEILING,
        DIVIDE_FLOOR,
        DIVIDE_HALF_UP,
        DIVIDE_HALF_DOWN,
        DIVIDE_HALF_EVEN,
        DIVIDE_UNNECESSARY;

    }
}

