/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangqin56.common;

import cn.zhangqin56.common.GlobalStatusCode;
import cn.zhangqin56.common.StatusCode;
import java.io.Serializable;

public class CommonResult<T>
implements Serializable {
    private static final StatusCode DEFAULT_SUCCESS_STATUS = GlobalStatusCode.SUCCESS;
    private static final StatusCode DEFAULT_ERROR_STATUS = GlobalStatusCode.INTERNAL_SERVER_ERROR;
    private Integer code;
    private T data;
    private String msg;

    private static <T> CommonResult<T> getResult(T data, StatusCode status) {
        return CommonResult.builder().data(data).msg(status.msg()).code(status.code()).build();
    }

    public static <T> CommonResult<T> success() {
        return CommonResult.success(null);
    }

    public static <T> CommonResult<T> success(T data) {
        return CommonResult.getResult(data, DEFAULT_SUCCESS_STATUS);
    }

    public static <T> CommonResult<T> success(T data, StatusCode statusCode) {
        return CommonResult.getResult(data, statusCode);
    }

    public static <T> CommonResult<T> error() {
        return CommonResult.error(null);
    }

    public static <T> CommonResult<T> error(T data) {
        return CommonResult.getResult(data, DEFAULT_ERROR_STATUS);
    }

    public static <T> CommonResult<T> error(T data, StatusCode statusCode) {
        return CommonResult.getResult(data, statusCode);
    }

    public static <T> CommonResult<T> simpleReturn(boolean b) {
        return b ? CommonResult.success() : CommonResult.error();
    }

    public static <T> CommonResultBuilder<T> builder() {
        return new CommonResultBuilder();
    }

    public Integer getCode() {
        return this.code;
    }

    public T getData() {
        return this.data;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonResult)) {
            return false;
        }
        CommonResult other = (CommonResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        return result;
    }

    public String toString() {
        return "CommonResult(code=" + this.getCode() + ", data=" + this.getData() + ", msg=" + this.getMsg() + ")";
    }

    public CommonResult() {
    }

    public CommonResult(Integer code, T data, String msg) {
        this.code = code;
        this.data = data;
        this.msg = msg;
    }

    public static class CommonResultBuilder<T> {
        private Integer code;
        private T data;
        private String msg;

        CommonResultBuilder() {
        }

        public CommonResultBuilder<T> code(Integer code) {
            this.code = code;
            return this;
        }

        public CommonResultBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public CommonResultBuilder<T> msg(String msg) {
            this.msg = msg;
            return this;
        }

        public CommonResult<T> build() {
            return new CommonResult<T>(this.code, this.data, this.msg);
        }

        public String toString() {
            return "CommonResult.CommonResultBuilder(code=" + this.code + ", data=" + this.data + ", msg=" + this.msg + ")";
        }
    }
}

