/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangqin56.common.spring.boot.starter;

import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.util.StopWatch;

@Aspect
@Configuration
@EnableAspectJAutoProxy
@ConditionalOnProperty(prefix="time.log", name={"enable"}, havingValue="true", matchIfMissing=true)
public class TimeLogAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(TimeLogAutoConfiguration.class);

    @Around(value="@annotation(cn.zhangqin56.common.spring.boot.starter.annotation.TimeLog)")
    public Object around(ProceedingJoinPoint proceedingJoinPoint) {
        String methodName = proceedingJoinPoint.getSignature().toLongString().split(" ")[2];
        StopWatch stopWatch = new StopWatch();
        stopWatch.start(methodName);
        Object res = proceedingJoinPoint.proceed();
        stopWatch.stop();
        logger.info("\u3010{}ms\u3011\u65b9\u6cd5\uff1a{}", (Object)stopWatch.prettyPrint(TimeUnit.MILLISECONDS), (Object)methodName);
        return res;
    }
}

