/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.api.explain;

import cn.zhangfusheng.api.annotation.ClassAnnotation;
import cn.zhangfusheng.api.config.ZfsApiConfig;
import cn.zhangfusheng.api.entity.ClassModel;
import cn.zhangfusheng.api.explain.MethodExplain;
import cn.zhangfusheng.api.util.ReflexUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ClassExplain {
    public static List<ClassModel> explain(String group) {
        String packagePath = null;
        try {
            packagePath = ZfsApiConfig.getGroupPackageMap(group);
        }
        catch (Exception e) {
            throw new RuntimeException("\u81f3\u5c11\u8981\u914d\u7f6e\u4e00\u4e2a\u8981\u626b\u63cf\u7684\u8def\u5f84");
        }
        ArrayList<ClassModel> classResultModels = new ArrayList<ClassModel>();
        List<Class<?>> classes = ReflexUtil.getClasses(packagePath);
        classes.forEach(clazz -> {
            ClassAnnotation clazzAnnotation = clazz.getAnnotation(ClassAnnotation.class);
            if (clazzAnnotation != null) {
                ClassModel classModel = ClassExplain.initClassModel(clazzAnnotation, clazz);
                List<Method> mehods = ReflexUtil.getMehods(clazz);
                classModel.setMethodModels(MethodExplain.explain(mehods));
                classResultModels.add(classModel);
            }
        });
        return classResultModels;
    }

    private static ClassModel initClassModel(ClassAnnotation annotation, Class clazz) {
        ClassModel classModel = new ClassModel();
        String className = annotation.name();
        className = StringUtils.isBlank((CharSequence)className) ? clazz.getName().replace(clazz.getPackage().getName(), "").replace(".", "") : className;
        classModel.setName(className);
        classModel.setDesc(annotation.desc());
        classModel.setGroup(annotation.group());
        classModel.setHidden(annotation.hidden());
        String path = annotation.path();
        if (path.indexOf("/") == 0) {
            path = path.substring(1, path.length());
        }
        if (path.lastIndexOf("/") == path.length()) {
            path = path.substring(0, path.length() - 1);
        }
        classModel.setPath(path);
        return classModel;
    }
}

