package cn.zhangfusheng.api.explain;

import cn.zhangfusheng.api.annotation.MethodAnnotation;
import cn.zhangfusheng.api.entity.Constant;
import cn.zhangfusheng.api.entity.MethodModel;
import cn.zhangfusheng.api.entity.ParameterModel;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/**
 * 方法注解解释
 *
 * @ClassName: MethodExplain
 * @Author: ZFS
 */
public class MethodExplain {

    public static List<MethodModel> explain(List<Method> mehods) {
        List<MethodModel> methodModels = new ArrayList<>();
        mehods.forEach(method -> {
            MethodAnnotation methodAnnotation = method.getAnnotation(MethodAnnotation.class);
            if (methodAnnotation != null) {
                MethodModel methodModel = new MethodModel();
                methodModel.setDesc(methodAnnotation.desc());
                methodModel.setHidden(methodAnnotation.hidden());
                String[] methodStr = methodAnnotation.method();
                if ("*".equals(methodStr[0])) {
                    methodStr = Constant.methodStr;
                }
                methodModel.setMethod(methodStr);
                String path = methodAnnotation.path();
                if (path.indexOf("/") == 0) {
                    path = path.substring(1, path.length());
                }
                if (path.lastIndexOf("/") == path.length()) {
                    path = path.substring(0, path.length() - 1);
                }
                methodModel.setPath(path);
                methodModel.setName(method.getName());
                ArrayList<ParameterModel> parameterModels = ParameterExplain.explain(methodAnnotation.parameterAnnotations());
                methodModel.setParameterModels(parameterModels);
                methodModels.add(methodModel);
            }
        });
        return methodModels;
    }

}
