package cn.zhangfusheng.api.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 方法注解
 *
 * @ClassName: MethodAnnotation
 * @Author: ZFS
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface MethodAnnotation {

    /**
     * 方法行为的描述
     *
     * @return string
     */
    String desc() default "";

    /**
     * 请求方式
     *
     * @return string
     */
    String [] method() default "GET";

    /**
     * 是否隐藏
     *
     * @return string
     */
    boolean hidden() default false;

    /**
     * 请求路径
     *
     * @return string
     */
    String path() default "";

    ParameterAnnotation[] parameterAnnotations() default {};
}
