package cn.zhangfusheng.api.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 类扫描注解
 *
 * @ClassName: ClassAnnotation
 * @Author: ZFS
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface ClassAnnotation {

    /**
     * 名称
     *
     * @return
     */
    String name() default "";

    /**
     * 分组
     *
     * @return string
     */
    String group() default "";

    /**
     * 描述
     *
     * @return string
     */
    String desc() default "";

    /**
     * 是否隐藏
     *
     * @return string
     */
    boolean hidden() default false;

    /**
     * 请求路径
     *
     * @return string
     */
    String path() default "";
}
