/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.api.explain;

import cn.zhangfusheng.api.annotation.ParameterAnnotation;
import cn.zhangfusheng.api.entity.ParameterModel;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ParameterExplain {
    public static ArrayList<ParameterModel> explain(ParameterAnnotation[] parameterAnnotations) {
        ArrayList<ParameterModel> parameterModels = new ArrayList<ParameterModel>();
        List<ParameterAnnotation> parameterAnnotationList = Arrays.asList(parameterAnnotations);
        parameterAnnotationList.forEach(parameterAnnotation -> {
            Class<?> parameterType = parameterAnnotation.type();
            if (!Object.class.getName().equals(parameterType.getName())) {
                List<Field> fields = Arrays.asList(parameterType.getDeclaredFields());
                fields.forEach(field -> {
                    field.setAccessible(true);
                    ParameterAnnotation modelParameterAnnotation = field.getAnnotation(ParameterAnnotation.class);
                    if (modelParameterAnnotation != null) {
                        parameterModels.add(ParameterExplain.initParameterModel(modelParameterAnnotation));
                    } else {
                        ParameterModel parameterModel = new ParameterModel();
                        parameterModel.setName(field.getName());
                        parameterModels.add(parameterModel);
                    }
                });
            } else {
                parameterModels.add(ParameterExplain.initParameterModel(parameterAnnotation));
            }
        });
        return parameterModels;
    }

    private static ParameterModel initParameterModel(ParameterAnnotation parameterAnnotation) {
        ParameterModel parameterModel = new ParameterModel();
        parameterModel.setDefaultValue(parameterAnnotation.defaultValue());
        String parameterName = parameterAnnotation.name();
        parameterName = StringUtils.isBlank((CharSequence)parameterName) ? parameterAnnotation.name() : parameterName;
        parameterModel.setName(parameterName);
        parameterModel.setDesc(parameterAnnotation.desc());
        parameterModel.setType(parameterAnnotation.type().getTypeName());
        parameterModel.setRequired(parameterAnnotation.required());
        return parameterModel;
    }
}

