package cn.zhangfusheng.api.rest;

import cn.zhangfusheng.api.config.ZfsApiConfig;
import cn.zhangfusheng.api.entity.ClassModel;
import cn.zhangfusheng.api.explain.ClassExplain;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @ClassName: ApiRest
 * @Author: ZFS
 * @Date: 2018/10/19 17:44
 */
@RestController
@RequestMapping("zfs/api")
public class ApiRest {

    @GetMapping("initPackage")
    public List<String> initPackage() {
        Map<String, String> groupPackageMap = ZfsApiConfig.getGroupPackageMap();
        ArrayList<String> apiPaths = new ArrayList<>(groupPackageMap.size());
        groupPackageMap.forEach((k, v) -> {
            apiPaths.add("zfs/api/initApi?group="+k);
        });
        return apiPaths;
    }

    @GetMapping("initApi")
    public List<ClassModel> initApi(@RequestParam(required = false, name = "group", defaultValue = "") String group) {
        return ClassExplain.explain(group);
    }
}
