package cn.zhangfusheng.api.config;

import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName: ZfsApiConfig
 * @Author: ZFS
 * @Date: 2018/10/19 15:23
 */
@Data
public class ZfsApiConfig {

    /**
     * 扫描多个包路径,需要分组
     * k=group
     * v=package
     */
    private Map<String, String> groupPackageMap;

    private static final ZfsApiConfig zfsApiConfig = new ZfsApiConfig();

    private ZfsApiConfig() {
    }

    /**
     * 初始化 配置
     *
     * @param packagePath 要扫描的包路径
     */
    public static void initZfsApiConfig(String packagePath) {
        HashMap<String, String> groupPackageMap = new HashMap<>(1);
        groupPackageMap.put("", packagePath);
        zfsApiConfig.setGroupPackageMap(groupPackageMap);
    }

    /**
     * 初始化配置
     *
     * @param groupPackageMap 组 包路径
     */
    public static void initZfsApiConfig(Map<String, String> groupPackageMap) {
        zfsApiConfig.setGroupPackageMap(groupPackageMap);
    }


    public static String getGroupPackageMap(String group) {
        return zfsApiConfig.groupPackageMap.get(group);
    }

    public static Map<String, String> getGroupPackageMap() {
        return zfsApiConfig.groupPackageMap;
    }
}
