package cn.zhangfusheng.api.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 参数列表扫描注解
 *
 * @ClassName: ParameterAnnotation
 * @Author: ZFS
 */
@Target({ElementType.METHOD,ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface ParameterAnnotation {

    /**
     * 参数名称
     *
     * @return string
     */
    String name();

    /**
     * 参数描述
     *
     * @return string
     */
    String desc() default "";

    /**
     * 默认值
     *
     * @return string
     */
    String defaultValue() default "";

    /**
     * 参数类型
     *
     * @return
     */
    Class<?> type() default Object.class;

    /**
     * 是否必填
     * @return
     */
    boolean required() default false;
}
