/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.transfer;

import cn.zhangfusheng.elasticsearch.annotation.ElasticSearchConfig;
import cn.zhangfusheng.elasticsearch.annotation.document.IndexTransfer;
import cn.zhangfusheng.elasticsearch.constant.ElasticSearchConstant;
import cn.zhangfusheng.elasticsearch.constant.enumeration.TransferType;
import cn.zhangfusheng.elasticsearch.cycle.CreateMappingBefore;
import cn.zhangfusheng.elasticsearch.cycle.CreateMappingEnd;
import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;
import cn.zhangfusheng.elasticsearch.exception.InitRepositoryException;
import cn.zhangfusheng.elasticsearch.model.annotation.DefaultElasticSearchConfig;
import cn.zhangfusheng.elasticsearch.model.page.PageRequest;
import cn.zhangfusheng.elasticsearch.scan.ElasticSearchEntityRepositoryDetail;
import cn.zhangfusheng.elasticsearch.template.ElasticSearchRestTemplate;
import cn.zhangfusheng.elasticsearch.thread.ThreadLocalDetail;
import cn.zhangfusheng.elasticsearch.transfer.TransferInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferOperation {
    private static final Logger log = LoggerFactory.getLogger(TransferOperation.class);
    private final ElasticSearchEntityRepositoryDetail entityRepositoryDetail;
    private final ElasticSearchRestTemplate elasticSearchRestTemplate;
    private final ElasticSearchConfig elasticSearchConfig;

    public TransferOperation(ElasticSearchEntityRepositoryDetail entityRepositoryDetail, ElasticSearchRestTemplate elasticSearchRestTemplate) {
        this.entityRepositoryDetail = entityRepositoryDetail;
        this.elasticSearchRestTemplate = elasticSearchRestTemplate;
        this.elasticSearchConfig = DefaultElasticSearchConfig.INSTANCE;
    }

    public void operationDocumentAndTransferDb() {
        TransferInfo transferInfo = this.upgradeIndex();
        if (BooleanUtils.isTrue((Boolean)transferInfo.getTransfer())) {
            this.transferDb(transferInfo.getUpIndexName(), transferInfo.getIndexName());
        }
        if (StringUtils.isBlank((CharSequence)transferInfo.getRowId())) {
            String rowId = UUIDs.randomBase64UUID();
            this.elasticSearchRestTemplate.index(rowId, null, ElasticSearchConstant.TRANSFER_INDEX, transferInfo.xContentBuilder(rowId));
        }
    }

    private TransferInfo upgradeIndex() {
        String entityClassName = this.entityRepositoryDetail.getEntityClass().getName();
        TransferInfo transferInfo = new TransferInfo().setClassName(entityClassName);
        ArrayList searchHits = new ArrayList(PageRequest.DEFAULT.getSize());
        this.elasticSearchRestTemplate.searchWithPage(hs -> searchHits.addAll(Arrays.asList(hs)), PageRequest.DEFAULT, new Object[]{new TransferInfo().setClassName(entityClassName)}, null, ElasticSearchConstant.TRANSFER_INDEX);
        if (searchHits.isEmpty()) {
            boolean indexExists = this.elasticSearchRestTemplate.exists(new GetIndexRequest(new String[]{this.entityRepositoryDetail.getIndexName()}));
            if (indexExists) {
                throw new GlobalSystemException("index[{}] exists,you must delete index or upgrade index,and restart project", this.entityRepositoryDetail.getIndexName());
            }
            this.createMappingBefore();
            this.elasticSearchRestTemplate.createIndexMapping(this.entityRepositoryDetail.getIndexName(), this.entityRepositoryDetail.getMapping(), this.entityRepositoryDetail.getSettingJson());
            this.createMappingEnd();
            return transferInfo.setTransfer(false).setDesc("\u521b\u5efaindex\u548cmapping").setIndexName(this.entityRepositoryDetail.getIndexName()).setVersion(this.entityRepositoryDetail.getIndexDiscription().version()).setUpgradeVersion(this.entityRepositoryDetail.getIndexDiscription().upgradeVersion());
        }
        transferInfo.setIndexName(this.entityRepositoryDetail.getIndexName()).setVersion(this.entityRepositoryDetail.getIndexDiscription().version()).setUpgradeVersion(this.entityRepositoryDetail.getIndexDiscription().upgradeVersion());
        SearchHit searchHit = (SearchHit)searchHits.get(searchHits.size() - 1);
        TransferInfo endTransferInfo = new TransferInfo(searchHit.getId(), searchHit.getSourceAsMap());
        if (!Objects.equals(transferInfo.getVersion(), endTransferInfo.getVersion())) {
            transferInfo.setTransfer(true).setUpIndexName(endTransferInfo.getIndexName());
            this.elasticSearchRestTemplate.createIndexMapping(transferInfo.getIndexName(), this.entityRepositoryDetail.getMapping(), this.entityRepositoryDetail.getSettingJson());
            transferInfo.setTransfer(true).setDesc("\u521b\u5efaindex\u548cmapping,\u5e76\u4e14\u8fc1\u79fb\u6570\u636e").setUpIndexName(endTransferInfo.getIndexName());
        } else if (!Objects.equals(transferInfo.getUpgradeVersion(), endTransferInfo.getUpgradeVersion())) {
            this.elasticSearchRestTemplate.putMapping(transferInfo.getIndexName(), this.entityRepositoryDetail.getMapping());
            transferInfo.setTransfer(false).setDesc("\u66f4\u65b0mapping");
        } else {
            transferInfo.setRowId(endTransferInfo.getRowId());
        }
        IndexTransfer indexTransfer = this.entityRepositoryDetail.getIndexTransfer();
        if (Objects.nonNull(indexTransfer)) {
            TransferInfo queryTransferInfo = new TransferInfo().setClassName(entityClassName).setTransferVersion(indexTransfer.upgradeVersion());
            List<SearchHit> transferSearchHits = this.elasticSearchRestTemplate.search(new Object[]{queryTransferInfo}, null, ElasticSearchConstant.TRANSFER_INDEX);
            if (transferSearchHits.isEmpty()) {
                transferInfo.setRowId(null).setTransfer(true).setUpIndexName(indexTransfer.sourceIndex()).setTransferVersion(indexTransfer.upgradeVersion());
            }
        }
        return transferInfo;
    }

    private void createMappingEnd() {
        Class<? extends CreateMappingEnd>[] createMappingEnd = this.entityRepositoryDetail.getIndexDiscription().createMappingEnd();
        if (Objects.nonNull(createMappingEnd) && createMappingEnd.length > 0) {
            try {
                for (Class<? extends CreateMappingEnd> aClass : createMappingEnd) {
                    aClass.newInstance().end(this.elasticSearchRestTemplate);
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new GlobalSystemException(e);
            }
        }
    }

    private void createMappingBefore() {
        Class<? extends CreateMappingBefore>[] createMappingBefore = this.entityRepositoryDetail.getIndexDiscription().createMappingBefore();
        if (Objects.nonNull(createMappingBefore) && createMappingBefore.length > 0) {
            try {
                for (Class<? extends CreateMappingBefore> c : createMappingBefore) {
                    c.newInstance().before(this.elasticSearchRestTemplate);
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new GlobalSystemException(e);
            }
        }
    }

    private void transferDb(String fromIndex, String toIndex) {
        try {
            TransferType transgerType = this.entityRepositoryDetail.getTransgerType();
            if (Objects.equals((Object)transgerType, (Object)TransferType.DEFAULT)) {
                ThreadLocalDetail.start(this.elasticSearchConfig);
                SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.matchAllQuery());
                SearchRequest searchRequest = new SearchRequest(new String[]{fromIndex}).source(searchSourceBuilder);
                SearchResponse searchResponse = this.elasticSearchRestTemplate.search(searchRequest, hs -> this.bulkTransgerDb(fromIndex, toIndex, (SearchHit[])hs));
                log.debug("dbSize:{}", (Object)searchResponse.getHits().getTotalHits().value);
            } else {
                this.elasticSearchRestTemplate.reindex(toIndex, fromIndex);
            }
        }
        catch (Exception e) {
            throw new InitRepositoryException(e);
        }
    }

    private void bulkTransgerDb(String fromIndex, String toIndex, SearchHit[] hits) {
        try {
            BulkRequest bulkRequest = new BulkRequest();
            Arrays.stream(hits).forEach(h -> {
                Map sourceAsMap = h.getSourceAsMap();
                String routing = this.entityRepositoryDetail.routing(sourceAsMap);
                XContentBuilder xContentBuilder = this.entityRepositoryDetail.mapToXContentBuilder(sourceAsMap);
                IndexRequest indexRequest = new IndexRequest(toIndex).routing(routing).id(h.getId()).source(xContentBuilder);
                bulkRequest.add(indexRequest);
            });
            BulkResponse bulkResponse = this.elasticSearchRestTemplate.restHighLevelClient().bulk(bulkRequest, RequestOptions.DEFAULT);
            if (bulkResponse.hasFailures()) {
                throw new GlobalSystemException(bulkResponse.buildFailureMessage());
            }
            log.debug("\u6570\u636e\u8fc1\u79fb:fromIndex:{}.toIndex:{}.dbSize:{}", new Object[]{fromIndex, toIndex, bulkRequest.numberOfActions()});
        }
        catch (IOException e) {
            throw new GlobalSystemException(e);
        }
    }
}

