/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.thread;

import cn.zhangfusheng.elasticsearch.annotation.ElasticSearchConfig;
import cn.zhangfusheng.elasticsearch.constant.ElasticSearchConstant;
import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;
import cn.zhangfusheng.elasticsearch.transactional.TransactionalControl;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.RandomUtils;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.tasks.TaskId;

public class ThreadLocalDetail {
    private static final ThreadLocal<ThreadLocalDetail> ES_THREAD_LOCAL_DETAIL = ThreadLocal.withInitial(ThreadLocalDetail::new);
    private TransactionalControl transactionalControl;
    private Boolean trackTotalHits;
    private Integer scrollSize;
    private Long keepAlive;
    private WriteRequest.RefreshPolicy refreshPolicy;

    public static ThreadLocalDetail start(ElasticSearchConfig elasticSearchConfig) {
        ThreadLocalDetail threadLocalDetail = ES_THREAD_LOCAL_DETAIL.get();
        if (elasticSearchConfig.openTransactional()) {
            if (Objects.isNull(threadLocalDetail.getTransactionalControl())) {
                TaskId taskId = new TaskId(UUIDs.randomBase64UUID(), RandomUtils.nextLong());
                threadLocalDetail.setTransactionalControl(new TransactionalControl(elasticSearchConfig.rollbackFor(), taskId));
            }
            threadLocalDetail.getTransactionalControl().addWaitExecute(1);
        }
        if (Objects.isNull(threadLocalDetail.refreshPolicy)) {
            threadLocalDetail.setRefreshPolicy(elasticSearchConfig.refreshPolicy());
        }
        if (Objects.isNull(threadLocalDetail.trackTotalHits)) {
            threadLocalDetail.trackTotalHits = elasticSearchConfig.trackTotalHits();
        }
        if (Objects.isNull(threadLocalDetail.scrollSize)) {
            if (elasticSearchConfig.scrollSize() > ElasticSearchConstant.MAX_DOC_SIZE) {
                throw new GlobalSystemException("{}.scrollSize > {}", ElasticSearchConfig.class.getName(), ElasticSearchConstant.MAX_DOC_SIZE);
            }
            threadLocalDetail.scrollSize = elasticSearchConfig.scrollSize();
        }
        if (Objects.isNull(threadLocalDetail.keepAlive)) {
            threadLocalDetail.keepAlive = elasticSearchConfig.keepAlive();
        }
        return threadLocalDetail;
    }

    public static void remove() {
        ES_THREAD_LOCAL_DETAIL.remove();
    }

    public static boolean addRequest(DocWriteRequest<?> ... requests) {
        TransactionalControl transactionalControl = ES_THREAD_LOCAL_DETAIL.get().getTransactionalControl();
        if (Objects.nonNull(transactionalControl)) {
            return transactionalControl.addRequest(requests);
        }
        return false;
    }

    public static Optional<TaskId> getTransactionTaskId() {
        TransactionalControl transactionalControl = ES_THREAD_LOCAL_DETAIL.get().getTransactionalControl();
        if (Objects.nonNull(transactionalControl)) {
            return Optional.ofNullable(transactionalControl.getTaskId());
        }
        return Optional.empty();
    }

    public static Optional<WriteRequest.RefreshPolicy> getRefreshPolicy() {
        ThreadLocalDetail threadLocalDetail = ES_THREAD_LOCAL_DETAIL.get();
        return Optional.ofNullable(threadLocalDetail.refreshPolicy);
    }

    public Optional<TransactionalControl> transactionaControl() {
        return Optional.ofNullable(ES_THREAD_LOCAL_DETAIL.get().getTransactionalControl());
    }

    public static boolean trackTotalHits() {
        Boolean trackTotalHits = ThreadLocalDetail.ES_THREAD_LOCAL_DETAIL.get().trackTotalHits;
        return Objects.isNull(trackTotalHits) ? Boolean.FALSE : trackTotalHits;
    }

    public static Optional<Integer> scrollSize() {
        return Optional.ofNullable(ThreadLocalDetail.ES_THREAD_LOCAL_DETAIL.get().scrollSize);
    }

    public static Optional<Long> keepAlive() {
        return Optional.ofNullable(ThreadLocalDetail.ES_THREAD_LOCAL_DETAIL.get().keepAlive);
    }

    public TransactionalControl getTransactionalControl() {
        return this.transactionalControl;
    }

    public Boolean getTrackTotalHits() {
        return this.trackTotalHits;
    }

    public Integer getScrollSize() {
        return this.scrollSize;
    }

    public Long getKeepAlive() {
        return this.keepAlive;
    }

    public void setTransactionalControl(TransactionalControl transactionalControl) {
        this.transactionalControl = transactionalControl;
    }

    public void setTrackTotalHits(Boolean trackTotalHits) {
        this.trackTotalHits = trackTotalHits;
    }

    public void setScrollSize(Integer scrollSize) {
        this.scrollSize = scrollSize;
    }

    public void setKeepAlive(Long keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThreadLocalDetail)) {
            return false;
        }
        ThreadLocalDetail other = (ThreadLocalDetail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$trackTotalHits = this.getTrackTotalHits();
        Boolean other$trackTotalHits = other.getTrackTotalHits();
        if (this$trackTotalHits == null ? other$trackTotalHits != null : !((Object)this$trackTotalHits).equals(other$trackTotalHits)) {
            return false;
        }
        Integer this$scrollSize = this.getScrollSize();
        Integer other$scrollSize = other.getScrollSize();
        if (this$scrollSize == null ? other$scrollSize != null : !((Object)this$scrollSize).equals(other$scrollSize)) {
            return false;
        }
        Long this$keepAlive = this.getKeepAlive();
        Long other$keepAlive = other.getKeepAlive();
        if (this$keepAlive == null ? other$keepAlive != null : !((Object)this$keepAlive).equals(other$keepAlive)) {
            return false;
        }
        TransactionalControl this$transactionalControl = this.getTransactionalControl();
        TransactionalControl other$transactionalControl = other.getTransactionalControl();
        if (this$transactionalControl == null ? other$transactionalControl != null : !this$transactionalControl.equals(other$transactionalControl)) {
            return false;
        }
        Optional<WriteRequest.RefreshPolicy> this$refreshPolicy = this.getRefreshPolicy();
        Optional<WriteRequest.RefreshPolicy> other$refreshPolicy = other.getRefreshPolicy();
        return !(this$refreshPolicy == null ? other$refreshPolicy != null : !((Object)this$refreshPolicy).equals(other$refreshPolicy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThreadLocalDetail;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $trackTotalHits = this.getTrackTotalHits();
        result = result * 59 + ($trackTotalHits == null ? 43 : ((Object)$trackTotalHits).hashCode());
        Integer $scrollSize = this.getScrollSize();
        result = result * 59 + ($scrollSize == null ? 43 : ((Object)$scrollSize).hashCode());
        Long $keepAlive = this.getKeepAlive();
        result = result * 59 + ($keepAlive == null ? 43 : ((Object)$keepAlive).hashCode());
        TransactionalControl $transactionalControl = this.getTransactionalControl();
        result = result * 59 + ($transactionalControl == null ? 43 : $transactionalControl.hashCode());
        Optional<WriteRequest.RefreshPolicy> $refreshPolicy = this.getRefreshPolicy();
        result = result * 59 + ($refreshPolicy == null ? 43 : ((Object)$refreshPolicy).hashCode());
        return result;
    }

    public String toString() {
        return "ThreadLocalDetail(transactionalControl=" + this.getTransactionalControl() + ", trackTotalHits=" + this.getTrackTotalHits() + ", scrollSize=" + this.getScrollSize() + ", keepAlive=" + this.getKeepAlive() + ", refreshPolicy=" + this.getRefreshPolicy() + ")";
    }
}

