/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.template;

import cn.zhangfusheng.elasticsearch.constant.ElasticSearchConstant;
import cn.zhangfusheng.elasticsearch.constant.enumeration.DyanmicType;
import cn.zhangfusheng.elasticsearch.dynamic.DyanmicExecuteResult;
import cn.zhangfusheng.elasticsearch.dynamic.DynamicAnalysis;
import cn.zhangfusheng.elasticsearch.dynamic.DynamicAnalysisDetail;
import cn.zhangfusheng.elasticsearch.dynamic.sql.es.ElasticSql2DslParser;
import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;
import cn.zhangfusheng.elasticsearch.model.page.PageRequest;
import cn.zhangfusheng.elasticsearch.repository.ElasticSearchRepository;
import cn.zhangfusheng.elasticsearch.scan.ElasticSearchEntityRepositoryDetail;
import cn.zhangfusheng.elasticsearch.template.ElasticSearchTemplateApi;
import cn.zhangfusheng.elasticsearch.template.Template;
import cn.zhangfusheng.elasticsearch.template.TemplateDocumentApi;
import com.alibaba.fastjson.JSON;
import io.github.iamazy.elasticsearch.dsl.sql.enums.SqlOperation;
import io.github.iamazy.elasticsearch.dsl.sql.model.ElasticSqlParseResult;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface TemplateDynamicStrApi
extends Template,
ElasticSearchTemplateApi,
TemplateDocumentApi {
    public static final Logger log = LoggerFactory.getLogger(TemplateDynamicStrApi.class);

    default public Object runDynamicStr(ElasticSearchEntityRepositoryDetail entityRepositoryDetail, Method method, Object[] args, String routing, String index) {
        try {
            Class<? extends ElasticSearchRepository<?>> daoClass = entityRepositoryDetail.getElasticSearchRepositoryClass();
            DynamicAnalysisDetail dynamicAnalysisDetail = new DynamicAnalysis().analysis(daoClass, method);
            DyanmicExecuteResult dyanmicExecuteResult = dynamicAnalysisDetail.execute(args);
            DyanmicType type = dyanmicExecuteResult.getType();
            switch (type) {
                case SQL: {
                    return this.runDynamicSql(entityRepositoryDetail, method, args, routing, index, dyanmicExecuteResult);
                }
                case DSL: {
                    return this.runDynamicDsl(entityRepositoryDetail, method, args, routing, index, dyanmicExecuteResult);
                }
            }
            throw new GlobalSystemException("DyanmicType \u5339\u914d\u5931\u8d25");
        }
        catch (Exception e) {
            throw new GlobalSystemException(e);
        }
    }

    default public Object runDynamicDsl(ElasticSearchEntityRepositoryDetail entityRepositoryDetail, Method method, Object[] args, String routing, String index, DyanmicExecuteResult dyanmicExecuteResult) throws IOException {
        String str = JSON.parseObject((String)dyanmicExecuteResult.getStrResult()).toJSONString();
        log.debug("dyanmic result dsl:{}", (Object)ElasticSearchConstant.PATTERN.matcher(str).replaceAll(" "));
        String[] indices = this.analysisIndex(method, args, index);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.wrapperQuery((String)str)).trackTotalHitsUpTo(10000);
        SearchRequest searchRequest = new SearchRequest().routing(routing).indices(indices).source(searchSourceBuilder);
        Optional<PageRequest> pageRequestOptional = Arrays.stream(args).filter(o -> o instanceof PageRequest).map(o -> (PageRequest)o).findFirst();
        return this.search(entityRepositoryDetail, method, searchRequest, pageRequestOptional.orElse(null));
    }

    default public Object runDynamicSql(ElasticSearchEntityRepositoryDetail entityRepositoryDetail, Method method, Object[] args, String routing, String index, DyanmicExecuteResult execute) throws IOException {
        String str = execute.getStrResult();
        log.debug("dyanmic result sql:{}", (Object)ElasticSearchConstant.PATTERN.matcher(str).replaceAll(" "));
        ElasticSqlParseResult parseResult = new ElasticSql2DslParser().parse(str);
        SqlOperation sqlOperation = parseResult.getSqlOperation();
        if (sqlOperation.equals((Object)SqlOperation.UPDATE)) {
            return this.update(((UpdateRequest)parseResult.getUpdateRequest().index(index)).routing(routing));
        }
        if (Objects.equals(sqlOperation, SqlOperation.UPDATE_BY_QUERY)) {
            UpdateByQueryRequest updateByQueryRequest = parseResult.getUpdateByQueryRequest();
            Script script = updateByQueryRequest.getScript();
            QueryBuilder queryBuilder = updateByQueryRequest.getSearchRequest().source().query();
            String[] indices = this.analysisIndex(method, args, index);
            return this.updateByQuery(queryBuilder, script, routing, indices);
        }
        if (Objects.equals(sqlOperation, SqlOperation.DELETE)) {
            return this.delete(((DeleteRequest)parseResult.getDeleteRequest().index(index)).routing(routing));
        }
        if (Objects.equals(sqlOperation, SqlOperation.DELETE_BY_QUERY)) {
            DeleteByQueryRequest deleteByQueryRequest = parseResult.getDeleteByQueryRequest();
            QueryBuilder queryBuilder = deleteByQueryRequest.getSearchRequest().source().query();
            String[] indices = this.analysisIndex(method, args, index);
            return this.deleteByQuery(queryBuilder, routing, indices);
        }
        if (Objects.equals(sqlOperation, SqlOperation.INSERT)) {
            return this.index((IndexRequest)parseResult.getIndexRequest().routing(routing).index(index));
        }
        if (Objects.equals(sqlOperation, SqlOperation.REINDEX) || Objects.equals(sqlOperation, SqlOperation.DESC)) {
            // empty if block
        }
        SearchSourceBuilder searchSourceBuilder = parseResult.getSearchRequest().source();
        searchSourceBuilder.trackTotalHitsUpTo(10000);
        String[] indices = this.analysisIndex(method, args, index);
        SearchRequest searchRequest = parseResult.getSearchRequest().source(searchSourceBuilder).routing(routing).indices(indices);
        Optional<PageRequest> pageRequestOptional = Arrays.stream(args).filter(o -> o instanceof PageRequest).map(o -> (PageRequest)o).findFirst();
        return this.search(entityRepositoryDetail, method, searchRequest, pageRequestOptional.orElse(null));
    }
}

