/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.template;

import cn.zhangfusheng.elasticsearch.template.TemplageIngestApi;
import cn.zhangfusheng.elasticsearch.template.Template;
import cn.zhangfusheng.elasticsearch.template.TemplateDocumentApi;
import cn.zhangfusheng.elasticsearch.template.TemplateDynamicSqlApi;
import cn.zhangfusheng.elasticsearch.template.TemplateDynamicStrApi;
import cn.zhangfusheng.elasticsearch.template.TemplateJpaApi;
import cn.zhangfusheng.elasticsearch.template.TemplateMybatisApi;
import cn.zhangfusheng.elasticsearch.template.TemplateSearchApi;
import java.util.function.BiConsumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;

public abstract class AbstractElasticSearchRestTemplate
implements Template,
TemplageIngestApi,
TemplateDocumentApi,
TemplateSearchApi,
TemplateJpaApi,
TemplateMybatisApi,
TemplateDynamicStrApi,
TemplateDynamicSqlApi {
    private final RestHighLevelClient restHighLevelClient;
    private final BulkProcessor bulkProcessor;

    protected AbstractElasticSearchRestTemplate(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
        this.bulkProcessor = this.buildBulkProcessor();
    }

    private BulkProcessor buildBulkProcessor() {
        BulkProcessor.Listener listener = new BulkProcessor.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
                System.out.println("beforeBulk:" + executionId);
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                System.out.println("afterBulk:" + executionId);
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                System.out.println("afterBulk:" + executionId);
            }
        };
        BiConsumer<BulkRequest, ActionListener> bulkRequestActionListenerBiConsumer = (bulkRequest, bulkResponseActionListener) -> this.restHighLevelClient.bulkAsync(bulkRequest, RequestOptions.DEFAULT, bulkResponseActionListener);
        return BulkProcessor.builder(bulkRequestActionListenerBiConsumer, (BulkProcessor.Listener)listener).setBulkActions(1000).setBulkSize(new ByteSizeValue(5L, ByteSizeUnit.MB)).setConcurrentRequests(0).setFlushInterval(TimeValue.timeValueSeconds((long)3L)).setBackoffPolicy(BackoffPolicy.constantBackoff((TimeValue)TimeValue.timeValueSeconds((long)1L), (int)5)).build();
    }

    @Override
    public RestHighLevelClient restHighLevelClient() {
        return this.restHighLevelClient;
    }

    @Override
    public BulkProcessor getBulkProcessor() {
        return this.bulkProcessor;
    }
}

