/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.scan;

import cn.zhangfusheng.elasticsearch.annotation.document.IndexDiscription;
import cn.zhangfusheng.elasticsearch.annotation.document.IndexTransfer;
import cn.zhangfusheng.elasticsearch.annotation.document.field.FieldMapping;
import cn.zhangfusheng.elasticsearch.annotation.document.field.MappingParameters;
import cn.zhangfusheng.elasticsearch.annotation.dsl.DslIndex;
import cn.zhangfusheng.elasticsearch.annotation.dsl.DslParams;
import cn.zhangfusheng.elasticsearch.constant.ElasticSearchConstant;
import cn.zhangfusheng.elasticsearch.constant.enumeration.FieldType;
import cn.zhangfusheng.elasticsearch.constant.enumeration.TransferType;
import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;
import cn.zhangfusheng.elasticsearch.exception.InitRepositoryException;
import cn.zhangfusheng.elasticsearch.model.analysis.AnalysisMapping;
import cn.zhangfusheng.elasticsearch.model.analysis.vo.ReturnDetail;
import cn.zhangfusheng.elasticsearch.model.page.PageResponse;
import cn.zhangfusheng.elasticsearch.repository.ElasticSearchRepository;
import cn.zhangfusheng.elasticsearch.util.date.LocalDateTimeUtils;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.search.SearchHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ElasticSearchEntityRepositoryDetail {
    private final Logger log;
    private final boolean ignoreTransferOperation;
    private Class<? extends ElasticSearchRepository<?>> elasticSearchRepositoryClass;
    private Class<?> entityClass;
    private Field primaryId;
    private Field createTime;
    private Field updateTime;
    private Field routing;
    private String repositoryBeanName;
    private IndexDiscription indexDiscription;
    private IndexTransfer indexTransfer;
    private List<Field> entityDeclaredFields;
    private List<Field> aliasFields;
    private Map<Method, Map<Integer, String>> methodParamsIndex;
    private String indexName;
    private String mapping;
    private String settingJson;

    public ElasticSearchEntityRepositoryDetail(boolean ignoreTransferOperation, Class<? extends ElasticSearchRepository<?>> elasticSearchRepositoryClass, Class<?> entityClass, IndexDiscription indexDiscription, IndexTransfer indexTransfer, String settingJson) {
        this.log = LoggerFactory.getLogger(elasticSearchRepositoryClass);
        this.elasticSearchRepositoryClass = elasticSearchRepositoryClass;
        this.ignoreTransferOperation = ignoreTransferOperation;
        this.entityClass = entityClass;
        this.indexDiscription = indexDiscription;
        this.indexTransfer = indexTransfer;
        this.settingJson = settingJson;
        this.repositoryBeanName = elasticSearchRepositoryClass.getName();
        this.entityDeclaredFields = Arrays.stream(FieldUtils.getAllFields(entityClass)).filter(field -> {
            FieldMapping fieldMapping = field.getAnnotation(FieldMapping.class);
            return !Objects.nonNull(fieldMapping) || !fieldMapping.ignore();
        }).peek(field -> field.setAccessible(true)).collect(Collectors.toList());
        this.aliasFields = this.entityDeclaredFields.stream().filter(field -> {
            FieldMapping fieldMapping = field.getAnnotation(FieldMapping.class);
            return Objects.nonNull(fieldMapping) && FieldType.Alias.equals((Object)fieldMapping.type());
        }).collect(Collectors.toList());
        this.init();
        ElasticSearchConstant.REPOSITORY_DETAIL_CACHE.put(this.entityClass, this);
    }

    private void init() {
        this.initIndexName();
        this.initOther();
    }

    private void initOther() {
        Optional<Field> primaryIdOption = this.entityDeclaredFields.stream().filter(o -> {
            FieldMapping fieldMapping = o.getAnnotation(FieldMapping.class);
            return Objects.nonNull(fieldMapping) && fieldMapping.primaryId();
        }).findFirst();
        this.primaryId = primaryIdOption.orElseThrow(() -> new GlobalSystemException("\u8bf7\u8bbe\u7f6e\u4e3b\u952e"));
        Optional<Field> createTimeOption = this.entityDeclaredFields.stream().filter(o -> {
            FieldMapping fieldMapping = o.getAnnotation(FieldMapping.class);
            return Objects.nonNull(fieldMapping) && fieldMapping.isCreateTime();
        }).findFirst();
        this.createTime = createTimeOption.orElse(null);
        Optional<Field> updateTimeOption = this.entityDeclaredFields.stream().filter(o -> {
            FieldMapping fieldMapping = o.getAnnotation(FieldMapping.class);
            return Objects.nonNull(fieldMapping) && fieldMapping.isUpdateTime();
        }).findFirst();
        this.updateTime = updateTimeOption.orElse(null);
        Optional<Field> routingOption = this.entityDeclaredFields.stream().filter(o -> {
            FieldMapping fieldMapping = o.getAnnotation(FieldMapping.class);
            return Objects.nonNull(fieldMapping) && fieldMapping.routing();
        }).findFirst();
        this.routing = routingOption.orElse(null);
        List<Method> methods = Arrays.asList(this.elasticSearchRepositoryClass.getMethods());
        this.methodParamsIndex = new HashMap<Method, Map<Integer, String>>(methods.size());
        methods.forEach(method -> {
            HashMap<Integer, String> paramIndex = new HashMap<Integer, String>(method.getParameterCount());
            Parameter[] parameters = method.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                DslParams dslParams = parameter.getAnnotation(DslParams.class);
                paramIndex.put(i, Objects.isNull(dslParams) ? String.format("arg_%s", i + 1) : dslParams.value());
            }
            this.methodParamsIndex.put((Method)method, (Map<Integer, String>)paramIndex);
        });
    }

    private void initIndexName() {
        String value = this.indexDiscription.value();
        if (StringUtils.isBlank((CharSequence)value)) {
            value = this.entityClass.getSimpleName();
        }
        int version = this.indexDiscription.version();
        this.indexName = String.format("%s_v%s", value.toLowerCase(), version);
    }

    public String getMapping() {
        try {
            if (StringUtils.isBlank((CharSequence)this.mapping)) {
                XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().startObject().startObject("properties");
                new AnalysisMapping(this.entityDeclaredFields).builder(xContentBuilder);
                xContentBuilder.endObject().endObject().flush();
                this.mapping = xContentBuilder.getOutputStream().toString();
                this.log.info("\n\tindexName:{}\n\tmapping:{}", (Object)this.indexName, (Object)this.mapping);
            }
            return this.mapping;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new InitRepositoryException(e);
        }
    }

    public Object analysisSearchResponse(SearchResponse searchResponse, List<SearchHit> hits, Method method, int skipTotal) {
        Class<?> methodReturnType = method.getReturnType();
        int resultType = -1;
        PageResponse pageResponse = null;
        if (List.class.isAssignableFrom(methodReturnType)) {
            resultType = 0;
        } else if (PageResponse.class.isAssignableFrom(methodReturnType)) {
            resultType = 1;
            pageResponse = new PageResponse();
            pageResponse.setTotal(searchResponse.getHits().getTotalHits()).setData(new ArrayList(hits.size())).setSkipTotal(skipTotal);
            if (!CollectionUtils.isEmpty(hits)) {
                Object[] sortValues = hits.get(hits.size() - 1).getSortValues();
                pageResponse.setSearchAfter(sortValues);
            }
        }
        if (resultType == -1 && hits.size() > 1) {
            throw new GlobalSystemException("result length > 1");
        }
        boolean resultIsOptional = methodReturnType.equals(Optional.class);
        Class<?> returnType = methodReturnType;
        DslIndex dslIndex = method.getAnnotation(DslIndex.class);
        if (Objects.nonNull(dslIndex) && !Objects.equals(dslIndex.returnType(), Void.class)) {
            returnType = dslIndex.returnType();
        }
        if (resultIsOptional && returnType.equals(Optional.class)) {
            throw new GlobalSystemException("\u8fd4\u56de\u503c\u7c7b\u578b\u4e3a Optional,\u8bf7\u4f7f\u7528 DslIndex \u914d\u7f6e returnType");
        }
        List objects = this.parseToEntity(hits, returnType);
        List result = resultType == -1 ? (objects.isEmpty() ? null : objects.get(0)) : (resultType == 0 ? objects : pageResponse.setData(objects));
        return resultIsOptional ? Optional.ofNullable(result) : result;
    }

    private Object getFieldValue(Field field, Object t) {
        if (Objects.isNull(field) || Objects.isNull(t)) {
            return null;
        }
        try {
            return this.operationValue(field, field.get(t), Boolean.TRUE);
        }
        catch (Exception e) {
            throw new GlobalSystemException(e);
        }
    }

    private <T> void setFieldValue(Field field, T t, Object value) {
        try {
            Object fieldValue = this.operationValue(field, value, Boolean.FALSE);
            field.set(t, fieldValue);
        }
        catch (Exception e) {
            throw new GlobalSystemException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> XContentBuilder entityToXContentBuilder(T t, boolean excludeNull) {
        try (XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().startObject();){
            for (Field field : this.entityDeclaredFields) {
                if (this.aliasFields.contains(field)) continue;
                Object fieldValue = this.getFieldValue(field, t);
                if (excludeNull) {
                    if (!ObjectUtils.isNotEmpty((Object)fieldValue)) continue;
                    xContentBuilder.field(field.getName(), fieldValue);
                    continue;
                }
                if (fieldValue instanceof Collection) {
                    xContentBuilder.field(field.getName(), (Iterable)((Collection)fieldValue));
                    continue;
                }
                xContentBuilder.field(field.getName(), fieldValue);
            }
            XContentBuilder xContentBuilder2 = xContentBuilder.endObject();
            return xContentBuilder2;
        }
        catch (IOException e) {
            throw new GlobalSystemException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XContentBuilder mapToXContentBuilder(Map<String, Object> sourceMap) {
        try (XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().startObject();){
            for (Field field : this.entityDeclaredFields) {
                if (this.aliasFields.contains(field)) continue;
                Object fieldValue = sourceMap.get(field.getName());
                if (fieldValue instanceof Collection) {
                    xContentBuilder.field(field.getName(), (Iterable)((Collection)fieldValue));
                    continue;
                }
                xContentBuilder.field(field.getName(), fieldValue);
            }
            XContentBuilder xContentBuilder2 = xContentBuilder.endObject();
            return xContentBuilder2;
        }
        catch (IOException e) {
            throw new GlobalSystemException(e);
        }
    }

    private Object operationValue(Field field, Object fieldValue, boolean serialize) throws IllegalAccessException {
        if (Objects.isNull(fieldValue)) {
            return null;
        }
        if (LocalDateTime.class.equals(field.getType()) || Date.class.equals(field.getType())) {
            String format = null;
            MappingParameters mappingParameters = field.getAnnotation(MappingParameters.class);
            if (Objects.nonNull(mappingParameters)) {
                format = mappingParameters.format();
            } else {
                MappingParameters parameters;
                FieldMapping fieldAnnotation = field.getAnnotation(FieldMapping.class);
                if (Objects.nonNull(fieldAnnotation) && Objects.nonNull(parameters = fieldAnnotation.mappingParameters()) && StringUtils.isNotBlank((CharSequence)parameters.format())) {
                    format = parameters.format();
                }
            }
            if (Objects.nonNull(format) && serialize) {
                LocalDateTime localDateTime = LocalDateTime.class.equals(field.getType()) ? (LocalDateTime)fieldValue : LocalDateTimeUtils.dateToLocalDateTime((Date)fieldValue);
                return LocalDateTimeUtils.format(localDateTime, format);
            }
            if (LocalDateTime.class.equals(field.getType())) {
                if (serialize) {
                    return LocalDateTimeUtils.localDateTimeToDate((LocalDateTime)fieldValue);
                }
                return LocalDateTimeUtils.parseMatches(String.valueOf(fieldValue));
            }
            if (serialize) {
                return fieldValue;
            }
            return LocalDateTimeUtils.localDateTimeToDate(LocalDateTimeUtils.parseMatches(String.valueOf(fieldValue)));
        }
        if (!serialize && fieldValue instanceof Map) {
            return new JSONObject((Map)fieldValue).toJavaObject(field.getType());
        }
        if (serialize) {
            if (fieldValue instanceof Collection && ObjectUtils.isNotEmpty((Object)fieldValue)) {
                Collection collection = (Collection)fieldValue;
                ArrayList result = new ArrayList(collection.size());
                for (Object o : collection) {
                    if (Objects.isNull(o.getClass().getClassLoader())) {
                        result.add(o);
                        continue;
                    }
                    Field[] declaredFields = o.getClass().getDeclaredFields();
                    HashMap<String, Object> result_ = new HashMap<String, Object>(declaredFields.length);
                    for (Field declaredField : declaredFields) {
                        declaredField.setAccessible(true);
                        Object value = this.operationValue(declaredField, declaredField.get(o), Boolean.TRUE);
                        result_.put(declaredField.getName(), value);
                        declaredField.setAccessible(false);
                    }
                    result.add(result_);
                }
                return result;
            }
            if (Objects.nonNull(field.getType().getClassLoader())) {
                Field[] declaredFields = field.getType().getDeclaredFields();
                HashMap<String, Object> result = new HashMap<String, Object>(declaredFields.length);
                for (Field declaredField : declaredFields) {
                    declaredField.setAccessible(true);
                    Object value = this.operationValue(declaredField, declaredField.get(fieldValue), Boolean.TRUE);
                    result.put(declaredField.getName(), value);
                    declaredField.setAccessible(false);
                }
                return result;
            }
        }
        return fieldValue;
    }

    public Optional<String> primaryId(Object t) {
        Object fieldValue = this.getFieldValue(this.primaryId, t);
        if (Objects.isNull(fieldValue)) {
            return Optional.empty();
        }
        String primaryId = String.valueOf(fieldValue);
        if (StringUtils.isBlank((CharSequence)primaryId)) {
            return Optional.empty();
        }
        return Optional.of(primaryId);
    }

    public String primaryIdIfNullSet(Object t) {
        Object fieldValue = this.getFieldValue(this.primaryId, t);
        String primaryId = String.valueOf(fieldValue);
        if (Objects.isNull(fieldValue) || StringUtils.isBlank((CharSequence)primaryId)) {
            primaryId = UUIDs.randomBase64UUID();
            this.setFieldValue(this.primaryId, t, primaryId);
        }
        return primaryId;
    }

    public String routing(Object t) {
        Object fieldValue = this.getFieldValue(this.routing, t);
        return Objects.isNull(fieldValue) ? null : String.valueOf(fieldValue);
    }

    public String routing(Map<String, Object> queryMap) {
        if (Objects.isNull(this.routing) || CollectionUtils.isEmpty(queryMap) || !queryMap.containsKey(this.routing.getName())) {
            return null;
        }
        return String.valueOf(queryMap.get(this.routing.getName()));
    }

    public String toString() {
        return String.format("\n\trepositoryBean:%s,\n\tentityBean:%s,\n\tindexName:%s,version:%s", this.repositoryBeanName, this.entityClass.getName(), this.indexName, this.indexDiscription.version());
    }

    public <T> List<T> parseToEntity(List<SearchHit> searchHits, Class<?> queryClass) {
        if (CollectionUtils.isEmpty(searchHits)) {
            return new ArrayList(0);
        }
        if (!ElasticSearchConstant.RETURN_DETAIL_CACHE.containsKey(queryClass)) {
            Class<?> returnType = this.entityClass;
            DslIndex returnTypeAnnotation = queryClass.getAnnotation(DslIndex.class);
            if (Objects.nonNull(returnTypeAnnotation) && !Objects.equals(returnTypeAnnotation.returnType(), Void.class)) {
                returnType = returnTypeAnnotation.returnType();
            }
            List<Field> entityDeclaredFields = Objects.isNull(returnType) ? this.entityDeclaredFields : Arrays.stream(FieldUtils.getAllFields(returnType)).peek(o -> o.setAccessible(Boolean.TRUE)).collect(Collectors.toList());
            ElasticSearchConstant.RETURN_DETAIL_CACHE.put(queryClass, new ReturnDetail(returnType, entityDeclaredFields));
        }
        ReturnDetail returnDetail = ElasticSearchConstant.RETURN_DETAIL_CACHE.get(queryClass);
        return Collections.synchronizedList(searchHits).parallelStream().map(s -> this.parseToEntity(s.getSourceAsMap(), returnDetail.getReturnType(), returnDetail.getFields())).collect(Collectors.toList());
    }

    public <T> T parseToEntity(Map<String, Object> source) {
        return this.parseToEntity(source, this.entityClass, this.entityDeclaredFields);
    }

    private <T> T parseToEntity(Map<String, Object> source, Class<?> entityClass, List<Field> entityDeclaredFields) {
        if (Objects.isNull(source)) {
            return null;
        }
        try {
            Object newInstance = entityClass.newInstance();
            entityDeclaredFields.forEach(o -> this.setFieldValue((Field)o, (Object)newInstance, source.get(o.getName())));
            return (T)newInstance;
        }
        catch (Exception e) {
            throw new GlobalSystemException(e);
        }
    }

    public TransferType getTransgerType() {
        TransferType transferType = this.indexDiscription.transferType();
        if (Objects.nonNull(this.indexTransfer) && Objects.equals((Object)transferType, (Object)TransferType.DEFAULT)) {
            return this.indexTransfer.type();
        }
        return transferType;
    }

    public ElasticSearchEntityRepositoryDetail setCreateTime(Object t) {
        this.getNowTime(this.createTime).ifPresent(nowTime -> this.setFieldValue(this.createTime, t, nowTime));
        return this;
    }

    public void setUpdateTime(Object t) {
        this.getNowTime(this.updateTime).ifPresent(nowTime -> this.setFieldValue(this.updateTime, t, nowTime));
    }

    private Optional<Object> getNowTime(Field field) {
        if (Objects.isNull(field)) {
            return Optional.empty();
        }
        if (field.getType().equals(LocalDateTime.class)) {
            return Optional.of(LocalDateTime.now());
        }
        if (field.getType().equals(Date.class)) {
            return Optional.of(new Date());
        }
        throw new GlobalSystemException("\u76ee\u524d\u53ea\u652f\u6301\u83b7\u53d6 LocalDateTime Date \u7684\u5f53\u524d\u65f6\u95f4");
    }

    public Logger getLog() {
        return this.log;
    }

    public boolean isIgnoreTransferOperation() {
        return this.ignoreTransferOperation;
    }

    public Class<? extends ElasticSearchRepository<?>> getElasticSearchRepositoryClass() {
        return this.elasticSearchRepositoryClass;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public Field getPrimaryId() {
        return this.primaryId;
    }

    public Field getCreateTime() {
        return this.createTime;
    }

    public Field getUpdateTime() {
        return this.updateTime;
    }

    public Field getRouting() {
        return this.routing;
    }

    public String getRepositoryBeanName() {
        return this.repositoryBeanName;
    }

    public IndexDiscription getIndexDiscription() {
        return this.indexDiscription;
    }

    public IndexTransfer getIndexTransfer() {
        return this.indexTransfer;
    }

    public List<Field> getEntityDeclaredFields() {
        return this.entityDeclaredFields;
    }

    public List<Field> getAliasFields() {
        return this.aliasFields;
    }

    public Map<Method, Map<Integer, String>> getMethodParamsIndex() {
        return this.methodParamsIndex;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getSettingJson() {
        return this.settingJson;
    }

    public void setElasticSearchRepositoryClass(Class<? extends ElasticSearchRepository<?>> elasticSearchRepositoryClass) {
        this.elasticSearchRepositoryClass = elasticSearchRepositoryClass;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public void setPrimaryId(Field primaryId) {
        this.primaryId = primaryId;
    }

    public void setRouting(Field routing) {
        this.routing = routing;
    }

    public void setRepositoryBeanName(String repositoryBeanName) {
        this.repositoryBeanName = repositoryBeanName;
    }

    public void setIndexDiscription(IndexDiscription indexDiscription) {
        this.indexDiscription = indexDiscription;
    }

    public void setIndexTransfer(IndexTransfer indexTransfer) {
        this.indexTransfer = indexTransfer;
    }

    public void setEntityDeclaredFields(List<Field> entityDeclaredFields) {
        this.entityDeclaredFields = entityDeclaredFields;
    }

    public void setAliasFields(List<Field> aliasFields) {
        this.aliasFields = aliasFields;
    }

    public void setMethodParamsIndex(Map<Method, Map<Integer, String>> methodParamsIndex) {
        this.methodParamsIndex = methodParamsIndex;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    public void setSettingJson(String settingJson) {
        this.settingJson = settingJson;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticSearchEntityRepositoryDetail)) {
            return false;
        }
        ElasticSearchEntityRepositoryDetail other = (ElasticSearchEntityRepositoryDetail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isIgnoreTransferOperation() != other.isIgnoreTransferOperation()) {
            return false;
        }
        Logger this$log = this.getLog();
        Logger other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        Class<ElasticSearchRepository<?>> this$elasticSearchRepositoryClass = this.getElasticSearchRepositoryClass();
        Class<? extends ElasticSearchRepository<?>> other$elasticSearchRepositoryClass = other.getElasticSearchRepositoryClass();
        if (this$elasticSearchRepositoryClass == null ? other$elasticSearchRepositoryClass != null : !this$elasticSearchRepositoryClass.equals(other$elasticSearchRepositoryClass)) {
            return false;
        }
        Class<?> this$entityClass = this.getEntityClass();
        Class<?> other$entityClass = other.getEntityClass();
        if (this$entityClass == null ? other$entityClass != null : !this$entityClass.equals(other$entityClass)) {
            return false;
        }
        Field this$primaryId = this.getPrimaryId();
        Field other$primaryId = other.getPrimaryId();
        if (this$primaryId == null ? other$primaryId != null : !((Object)this$primaryId).equals(other$primaryId)) {
            return false;
        }
        Field this$createTime = this.getCreateTime();
        Field other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Field this$updateTime = this.getUpdateTime();
        Field other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        Field this$routing = this.getRouting();
        Field other$routing = other.getRouting();
        if (this$routing == null ? other$routing != null : !((Object)this$routing).equals(other$routing)) {
            return false;
        }
        String this$repositoryBeanName = this.getRepositoryBeanName();
        String other$repositoryBeanName = other.getRepositoryBeanName();
        if (this$repositoryBeanName == null ? other$repositoryBeanName != null : !this$repositoryBeanName.equals(other$repositoryBeanName)) {
            return false;
        }
        IndexDiscription this$indexDiscription = this.getIndexDiscription();
        IndexDiscription other$indexDiscription = other.getIndexDiscription();
        if (this$indexDiscription == null ? other$indexDiscription != null : !this$indexDiscription.equals(other$indexDiscription)) {
            return false;
        }
        IndexTransfer this$indexTransfer = this.getIndexTransfer();
        IndexTransfer other$indexTransfer = other.getIndexTransfer();
        if (this$indexTransfer == null ? other$indexTransfer != null : !this$indexTransfer.equals(other$indexTransfer)) {
            return false;
        }
        List<Field> this$entityDeclaredFields = this.getEntityDeclaredFields();
        List<Field> other$entityDeclaredFields = other.getEntityDeclaredFields();
        if (this$entityDeclaredFields == null ? other$entityDeclaredFields != null : !((Object)this$entityDeclaredFields).equals(other$entityDeclaredFields)) {
            return false;
        }
        List<Field> this$aliasFields = this.getAliasFields();
        List<Field> other$aliasFields = other.getAliasFields();
        if (this$aliasFields == null ? other$aliasFields != null : !((Object)this$aliasFields).equals(other$aliasFields)) {
            return false;
        }
        Map<Method, Map<Integer, String>> this$methodParamsIndex = this.getMethodParamsIndex();
        Map<Method, Map<Integer, String>> other$methodParamsIndex = other.getMethodParamsIndex();
        if (this$methodParamsIndex == null ? other$methodParamsIndex != null : !((Object)this$methodParamsIndex).equals(other$methodParamsIndex)) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        String this$mapping = this.getMapping();
        String other$mapping = other.getMapping();
        if (this$mapping == null ? other$mapping != null : !this$mapping.equals(other$mapping)) {
            return false;
        }
        String this$settingJson = this.getSettingJson();
        String other$settingJson = other.getSettingJson();
        return !(this$settingJson == null ? other$settingJson != null : !this$settingJson.equals(other$settingJson));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElasticSearchEntityRepositoryDetail;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIgnoreTransferOperation() ? 79 : 97);
        Logger $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        Class<ElasticSearchRepository<?>> $elasticSearchRepositoryClass = this.getElasticSearchRepositoryClass();
        result = result * 59 + ($elasticSearchRepositoryClass == null ? 43 : $elasticSearchRepositoryClass.hashCode());
        Class<?> $entityClass = this.getEntityClass();
        result = result * 59 + ($entityClass == null ? 43 : $entityClass.hashCode());
        Field $primaryId = this.getPrimaryId();
        result = result * 59 + ($primaryId == null ? 43 : ((Object)$primaryId).hashCode());
        Field $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Field $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        Field $routing = this.getRouting();
        result = result * 59 + ($routing == null ? 43 : ((Object)$routing).hashCode());
        String $repositoryBeanName = this.getRepositoryBeanName();
        result = result * 59 + ($repositoryBeanName == null ? 43 : $repositoryBeanName.hashCode());
        IndexDiscription $indexDiscription = this.getIndexDiscription();
        result = result * 59 + ($indexDiscription == null ? 43 : $indexDiscription.hashCode());
        IndexTransfer $indexTransfer = this.getIndexTransfer();
        result = result * 59 + ($indexTransfer == null ? 43 : $indexTransfer.hashCode());
        List<Field> $entityDeclaredFields = this.getEntityDeclaredFields();
        result = result * 59 + ($entityDeclaredFields == null ? 43 : ((Object)$entityDeclaredFields).hashCode());
        List<Field> $aliasFields = this.getAliasFields();
        result = result * 59 + ($aliasFields == null ? 43 : ((Object)$aliasFields).hashCode());
        Map<Method, Map<Integer, String>> $methodParamsIndex = this.getMethodParamsIndex();
        result = result * 59 + ($methodParamsIndex == null ? 43 : ((Object)$methodParamsIndex).hashCode());
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        String $mapping = this.getMapping();
        result = result * 59 + ($mapping == null ? 43 : $mapping.hashCode());
        String $settingJson = this.getSettingJson();
        result = result * 59 + ($settingJson == null ? 43 : $settingJson.hashCode());
        return result;
    }
}

